<?php


include 'requires.php';


class printController
{
    const ZAM_NIEZREALIZOWANE = 5,
        ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI = 6,
        ZAM_NIEZREALIZOWANE_Z_REZERWACJA = 7;

    const STATUS_EX_NIE_ZREALIZOWANE = 0,
          STATUS_EX_ZREALIZOWANE_CZESCIOWO = 1,
          STATUS_EX_ZREALIZOWANE_FS_ZAL_POSREDNIA = 8;

    const ZAMOWIENIE_OD_KLIENTOW = 16,
        ZAMOWIENIE_DO_DOSTAWCOW = 15,
        WYDANIE_ZEWNETRZNE = 11,
        PRZYJECIE_ZEWNETRZNE = 10;

    const PODTYP_ZAMOWIENIE_ZALICZKOWE = 1;

    public function indexAction()
    {

        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();

        $orders = [];
        $filters = [];

        $docType = self::ZAMOWIENIE_OD_KLIENTOW;
        $magId = 0;
        $konId = 0;

        if(isset($_POST['renderTable']) && $_POST['renderTable'] == 1){

            $magId = $_POST['magazine'];
            // $konId = $_POST['client'];

        }

        echo $twig->render('print/index.html.twig', [
            'orders' => $this->getDocs($docType, $magId, $konId),
            'magazines' => $this->getMagazines(),
            'clients' => $this->getClients(),
            'filters' => $this->getFilters()
            ]);

    }

    public function generatePrintAction(){


        $ordersIds = (isset($_POST['orders'])) ? $_POST['orders'] : [];


        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();

        $orders = [];
        $filters = [];


        $magId = $_POST['magazine'];
        $konId = $_POST['client'];

        if(count($ordersIds) > 0){
            $checkedOrders = $pdo->query("SELECT d.*, k.kh_Symbol, k.kh_Id, 
                                            ah.*, ph.*, a.*, p.pa_KodPanstwaUE as kodUE, e.*, pw.pwd_Liczba01 FROM dbo.dok__Dokument d 
                                            LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
                                            LEFT JOIN dbo.adr_Historia ah ON d.dok_AdresDostawyAdreshId = ah.adrh_Id
                                            LEFT JOIN dbo.sl_Panstwo ph ON ph.pa_Id = ah.adrh_IdPanstwo
                                            LEFT JOIN dbo.adr__Ewid a ON d.dok_PlatnikId = a.adr_IdObiektu AND a.adr_TypAdresu = 1
                                            LEFT JOIN dbo.sl_Panstwo p ON p.pa_Id = a.adr_IdPanstwo
                                            LEFT JOIN dbo.adr_Email e ON e.am_IdAdres = a.adr_Id AND e.am_Podstawowy = 1
                                            LEFT JOIN dbo.pw_Dane pw ON pw.pwd_IdObiektu = k.kh_Id
                                            WHERE d.dok_Id IN(".implode(',', $ordersIds).") ORDER BY CASE WHEN pw.pwd_Liczba01 IS NULL THEN 1 ELSE 0 END, pw.pwd_Liczba01");
            $checkedOrders = $checkedOrders->fetchAll();

            $print = [];

            foreach ($checkedOrders as $order) {

                $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol, t.tw_Nazwa FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokHanId = ".$order['dok_Id']." ");
                $pozycje = $pozycje->fetchAll();

                // jezeli zamowienie zaliczkowe pobieramy wydane wczesniej pozycje
                if($order['dok_Podtyp'] == self::PODTYP_ZAMOWIENIE_ZALICZKOWE){
                    $pozycjeWydane = $this->getPozycjeWydane($order['dok_Id']);
                }


                foreach($pozycje as $pozycja){

                    $print[] = [
                        "pozycja" => $pozycja['tw_Symbol'],
                        "order" => $order['dok_NrPelny'],
                        "ilosc" => $pozycja['ob_Ilosc'],
                        "nazwa" => $pozycja['tw_Nazwa']
                    ];

                }
            }

            usort($print, function ($a, $b) {
                return strcmp($a["pozycja"], $b["pozycja"]);
            });


//            var_dump($warnings);
//            var_dump($errors);
//            die(var_dump($pzTowary));


            echo $twig->render('print/print.html.twig', [
                'print' => $print
            ]);
            exit();
        }

        echo $twig->render('print/print.html.twig', [
            'orders' => $this->getDocs(self::ZAMOWIENIE_OD_KLIENTOW, $magId, $konId),
            'magazines' => $this->getMagazines(),
            'clients' => $this->getClients(),
            'filters' => $this->getFilters(),
        ]);

    }

    private function getPozycjeWydane($dokId){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $wzs = $pdo->query("SELECT d.* FROM dbo.dok__Dokument d 
                                            WHERE d.dok_Typ = ".self::WYDANIE_ZEWNETRZNE." AND d.dok_DoDokId = ".$dokId." ");
        $wzs = $wzs->fetchAll();

        $pzTowary = [];

        foreach ($wzs as $wz) {

            $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokMagId = " . $wz['dok_Id'] . " ");
            $pozycje = $pozycje->fetchAll();

            foreach ($pozycje as $pozycja) {
                if (!array_key_exists($pozycja["tw_Symbol"], $pzTowary)) {
                    $pzTowary[$pozycja["tw_Symbol"]] = 0;
                }
                $pzTowary[$pozycja["tw_Symbol"]] += $pozycja["ob_Ilosc"];
            }

        }

        return $pzTowary;

    }

    private function getDocs($docType, $magId, $konId = 0){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $andWhere = "";
        $orderBy = "";

        if($docType == self::ZAMOWIENIE_OD_KLIENTOW){
            $docStatuses = [self::ZAM_NIEZREALIZOWANE, self::ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI, self::ZAM_NIEZREALIZOWANE_Z_REZERWACJA];
            $docExStatuses = [self::STATUS_EX_NIE_ZREALIZOWANE, self::STATUS_EX_ZREALIZOWANE_CZESCIOWO, self::STATUS_EX_ZREALIZOWANE_FS_ZAL_POSREDNIA];
            $andWhere = "AND d.dok_Status IN(".implode(',', $docStatuses).") AND d.dok_StatusEx IN(".implode(',', $docExStatuses).")";
            $orderBy = "ORDER BY CASE WHEN pw.pwd_Liczba01 IS NULL THEN 1 ELSE 0 END, pw.pwd_Liczba01";
        }


        $orders = $pdo->query("SELECT d.dok_Id, d.dok_NrPelny, k.kh_Symbol, pw.pwd_Liczba01 FROM dbo.dok__Dokument d 
                                            LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
                                            LEFT JOIN dbo.pw_Dane pw ON pw.pwd_IdObiektu = k.kh_Id
                                            WHERE d.dok_MagId = $magId AND d.dok_Typ = ".$docType." ".$andWhere." ".$orderBy." ");
        $orders = $orders->fetchAll();

        // AND k.kh_Id = ".$konId."

        foreach ($orders as $key => $order){

            $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol, t.tw_Objetosc FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokHanId = ".$order['dok_Id']." ");
            $pozycje = $pozycje->fetchAll();

            $objetosc = 0;

            foreach($pozycje as $pozycja){
                $objetosc += $pozycja['tw_Objetosc'] * $pozycja['ob_Ilosc'];
            }

            $orders[$key]['objetosc'] = $objetosc;

        }


        return $orders;

    }

    private function getFilters(){
        $filters = [
            'magazine' => (isset($_POST['magazine'])) ?  $_POST['magazine'] : 0,
            'client' => (isset($_POST['client'])) ?  $_POST['client'] : 0,
            'renderTable' => (isset($_POST['renderTable']) && $_POST['renderTable'] == 1) ?  1 : 0,
        ];

        return $filters;
    }

    private function getMagazines(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $magazyny = $pdo->query("SELECT m.* FROM dbo.sl_Magazyn m ORDER BY m.mag_Nazwa");
        $magazyny = $magazyny->fetchAll();

        return $magazyny;

    }

    private function getClients(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $kontrahenci = $pdo->query('SELECT k.*, a.* FROM dbo.kh__Kontrahent k 
                        LEFT JOIN dbo.adr__Ewid a ON k.kh_Id=a.adr_IdObiektu AND a. adr_TypAdresu = 1');
        $kontrahenci = $kontrahenci->fetchAll();

        return $kontrahenci;
    }

    private function prepareCSV($aData, $sSeparator)
    {
        $aCSV = array();

        foreach($aData as $aRow) {
            $aCSV[] = implode($sSeparator, $aRow);
        }

        return implode("\n", $aCSV);
    }


}


?>
