'use strict';

(function (window, $) {
    window.PrintApp = function ($wrapper) {

        this.$wrapper = $wrapper;

        this._inits();


        this.$wrapper.on(
            'click',
            '#closeFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#openFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#checkAll',
            this.toggleCheckAll.bind(this)
        );

        this.$wrapper.on(
            'change',
            '.changeCh',
            this.sumVolume.bind(this)
        );


    };

    $.extend(window.PrintApp.prototype, {


        toggleFilters: function (e) {
            e.preventDefault();
            $('#closeFilters, #openFilters, #filters').toggle();
        },

        toggleCheckAll: function (e) {

            if($('#checkAll').prop('checked') == true){
                $('.ordersCh').prop('checked', true);
            }
            else{
                $('.ordersCh').prop('checked', false);
            }

        },

        sumVolume: function (e) {

            e.preventDefault();

            var self = e.currentTarget;

            var sum = 0;
            $( ".tdVolume" ).each(function() {

                var id = $(this).attr('data-id');

                if($('#ch-' + id).prop('checked') == true){
                    sum = sum + parseFloat($(this).html());
                }


            });


            $("#sumVolume").html(sum);

        },


        _inits: function (e) {
            $('.dropdown').dropdown({
                'fullTextSearch': true,
            });


            $('.chosen').chosen();


            jQuery.extend(jQuery.fn.dataTableExt.oSort, {
                "polish-string-asc": function (s1, s2) {
                    return s1.localeCompare(s2);
                },

                "polish-string-desc": function (s1, s2) {
                    return s2.localeCompare(s1);
                }
            });

            var wHeight = window.innerHeight;


            var table = $('#dataTable').DataTable({
                responsive: false,
                bPaginate: false,
                bLengthChange: false,
                bFilter: false,
                bInfo: false,
                bAutoWidth: false,
                aLengthMenu: [[-1, 10, 50, 100], ["Wszystkie", 10, 50, 100]],
                aaSorting: []


            });
        },

    });

})(window, jQuery);