<?php

namespace App\Http\Controllers;

use Exception;
use Laravel\Lumen\Routing\Controller as BaseController;


class LogsController extends BaseController
{
    /**
     * @return string
     */
    public function inventoryLogs(): string
    {
        return file_get_contents(storage_path('synchronize-inventory.txt'));
    }

    /**
     * @return string
     */
    public function waybillsLogs(): string
    {
        return file_get_contents(storage_path('synchronize-waybills.txt'));
    }

    /**
     * @return string
     */
    public function pingLogs(): string
    {
        return file_get_contents(storage_path('ping-command.txt'));
    }

    /**
     * Wyświetla logi z przejścia programu
     *
     * @return string
     */
    public function runtimeLogs(): string
    {
        return file_get_contents(storage_path('logi.txt'));
    }

    /**
     * @return string
     */
    public function errorsLogs(): string
    {
        return file_get_contents(storage_path('logs/lumen-' . date('Y-m-d') . '.log'));
    }

    /**
     * @param  string  $date
     *
     * @return string
     */
    public function errorsDateLogs(string $date): string
    {
        if ($date === null || $date === '') {
            $date = date('Y-m-d');
        }

        return file_get_contents(storage_path('logs/lumen-' . $date . '.log'));
    }
}
