<?php

namespace App\Console\Commands;

use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Log;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Console\Command;

class SynchronizeWaybills extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'synchronize-waybills';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Synchronizuje numery listów przewozowych z Subiekta z zewnętrznym sklepem';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @throws Exception
     */
    public function handle()
    {
        Log::info('[START] ' . $this->description);
        $this->log('info', '[START]' . $this->description);

        try {
            $warehouse = config('project.warehouse', null);
            $date = new \DateTime();
            $date->modify('-3 months');

            $dateSql = $date->format('Y-m-d H:i:s');

            $documents = DB::select('SELECT dbo.dok__Dokument.dok_Typ, dbo.dok__Dokument.dok_MagId, dbo.fl_Wartosc.flw_IdFlagi, dbo.dok__Dokument.dok_NrPelnyOryg, dbo.dok__Dokument.dok_NrPelny, dbo.pw_Dane.pwd_TypObiektu AS Expr1,
                         dbo.fl_Wartosc.flw_IdGrupyFlag, dbo.fl_Wartosc.flw_IdObiektu, dbo.pw_Dane.pwd_Liczba01 AS Expr2, dbo.pw_Dane.pwd_Tekst01, dbo.dok__Dokument.dok_DataWyst
FROM            dbo.dok__Dokument INNER JOIN
                         dbo.fl_Wartosc ON dbo.dok__Dokument.dok_Id = dbo.fl_Wartosc.flw_IdObiektu INNER JOIN
                         dbo.pw_Dane ON dbo.dok__Dokument.dok_Id = dbo.pw_Dane.pwd_IdObiektu
WHERE        (dbo.dok__Dokument.dok_MagId = :warehouseId) AND (dbo.dok__Dokument.dok_Typ = 16) AND (dbo.fl_Wartosc.flw_IdGrupyFlag = 8) AND (dbo.pw_Dane.pwd_TypObiektu = - 8) AND (dbo.pw_Dane.pwd_Liczba01 = 20) AND
                         (dbo.dok__Dokument.dok_DataWyst > CONVERT(DATETIME, :date, 102))',
                [ 'warehouseId' => $warehouse, 'date' => $dateSql ]);

            $this->log('info', '[warehouse]' . print_r($warehouse, true));
            $this->log('info', '[documents]' . print_r($documents, true));

            if (!$documents) {
                $this->log('error', 'Nie udało się pobrać listów przewozowych z bazy.');

                return;
            }

            $this->log('info', '[docs map]');

            $documentsToSend = [];
            foreach ($documents as $document) {
                if (isset($document->dok_NrPelnyOryg) && isset($document->pwd_Tekst01)) {
                    $documentsToSend[$document->dok_NrPelnyOryg] = $document->pwd_Tekst01;
                }
            }

            $this->log('info', '[documents]' . print_r($documentsToSend, true));

            $this->log('info', "Wysyłam: " . count($documentsToSend) . " dokumentów!");

            try {
                $client = new Client();
                $response = $client->post(config('project.shop.urlWaybills') . '?token=' . config('project.shop.token'), [
                    'json' => $documentsToSend,
                    'connect_timeout' => 300,
                    'timeout' => 300,
                ]);
                $this->log('success',
                    'Numery listów przewozowych wysłane: ' . count($documentsToSend) . ', sklep zwrócił status: ' . $response->getBody()->getContents());
            } catch (Exception $e) {
                $this->log('error',
                    'Nie udało się wysłać numerów listów przewozowych: ' . count($documentsToSend) . ', sklep zwrócił błąd: ' . $e->getMessage());
            }
        } catch
        (QueryException $e) {
            $documents = false;
        }

        Log::info('[END] ' . $this->description);
        $this->log('info', '[END]' . $this->description);
    }

    protected function log($status, $message)
    {
        $status = strtoupper($status);

        if (!in_array($status, [ 'SUCCESS', 'ERROR', 'WARNING', 'INFO' ])) {
            $status = 'INFO';
        }

        $log = implode(' ', [
                date('Y-m-d H:i:s'),
                $status,
                $message,
            ]) . PHP_EOL;
        file_put_contents(storage_path($this->signature . '.txt'), $log, FILE_APPEND);
    }
}
