<?php

namespace App\Http\Controllers;

use Exception;
use Laravel\Lumen\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Artisan;


class CommandsController extends BaseController
{
    /**
     * @return string
     */
    public function pingCommand(): string
    {
        $timeStart = microtime(true);

        Artisan::call('ping-command');

        return 'ping-command: ' . (microtime(true) - $timeStart);
    }

    /**
     * @return string
     */
    public function inventoryCommand(): string
    {
        $timeStart = microtime(true);

        Artisan::call('synchronize-inventory');

        return 'synchronize-inventory: ' . (microtime(true) - $timeStart);
    }

    /**
     * @return string
     */
    public function waybillsCommand(): string
    {
        $timeStart = microtime(true);

        Artisan::call('synchronize-waybills');

        return 'synchronize-waybills: ' . (microtime(true) - $timeStart);
    }
}
