<?php

namespace App\Console;

use App\Console\Commands\SynchronizeInventory;
use App\Console\Commands\SynchronizeWaybills;
use App\Console\Commands\PingCommand;
use Illuminate\Console\Scheduling\Schedule;
use Laravel\Lumen\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        'ping-command' => PingCommand::class,
        'synchronize-inventory' => SynchronizeInventory::class,
        'synchronize-waybills' => SynchronizeWaybills::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('ping-command')->everyMinute()->name('ping command')->withoutOverlapping();
        $schedule->command('synchronize-inventory')->everyFifteenMinutes()->name('subiekt stany magazynowe')->withoutOverlapping();
        $schedule->command('synchronize-waybills')->cron('10-59/15 * * * *')->name('subiekt listy przewozowe')->withoutOverlapping();
    }
}
