<?php

namespace App\Console\Commands;

use Log;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Console\Command;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;

class PingCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ping-command';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Ping command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->log('info', $this->description);
    }

    protected function log($status, $message)
    {
        $status = strtoupper($status);

        if (!in_array($status, [ 'SUCCESS', 'ERROR', 'WARNING', 'INFO' ])) {
            $status = 'INFO';
        }

        $log = implode(' ', [
                date('Y-m-d H:i:s'),
                $status,
                $message,
            ]) . PHP_EOL;
        file_put_contents(storage_path($this->signature . '.txt'), $log, FILE_APPEND);
    }
}
