'use strict';

(function (window, $, myFilters) {
    window.IdOrderApp = function ($wrapper) {

        this.$wrapper = $wrapper;

        this._inits();

        this.$wrapper.on(
            'click',
            '.new',
            this.alertIt.bind(this)
        );

        this.$wrapper.find('#test').on(
            'click',
            '.test',
            this.alertIt.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#closeFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#openFilters',
            this.toggleFilters.bind(this)
        );

    };

    $.extend(window.IdOrderApp.prototype, {

        alertIt: function (e) {
            e.preventDefault();
            alert("it's working");
        },

        toggleFilters: function (e) {
            e.preventDefault();
            $('#closeFilters, #openFilters, #filters').toggle();
        },
        _inits: function (e) {
            $('.dropdown').dropdown();


            $('.chosen').chosen();


            $("#dateFrom").flatpickr({locale: "pl", defaultDate: myFilters.dateFrom});
            $("#dateTo").flatpickr({locale: "pl", defaultDate: myFilters.dateTo});

            jQuery.extend( jQuery.fn.dataTableExt.oSort, {
                "polish-string-asc" : function (s1, s2) {
                    return s1.localeCompare(s2);
                },

                "polish-string-desc" : function (s1, s2) {
                    return s2.localeCompare(s1);
                }
            } );

            var wHeight = window.innerHeight;


            var table = $('#dataTable').DataTable({
                responsive: false,
                fixedColumns: {
                    leftColumns: 4
                },
                scrollX: true,
                scrollY: (wHeight - 300) + "px",
                bPaginate: false,
                bLengthChange: false,
                bFilter: false,
                bInfo: false,
                bAutoWidth: false,
                // columnDefs: [{
                //     type: 'polish-string',
                //     targets: 1
                // }],
                aLengthMenu: [[-1, 10, 50, 100], ["Wszystkie", 10, 50, 100]],


            });


        },

    });

})(window, jQuery, $myFilters);