<?php

include 'requires.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ordersController
{
    const ZAM_NIEZREALIZOWANE = 5,
        ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI = 6,
        ZAM_NIEZREALIZOWANE_Z_REZERWACJA = 7;

    const STATUS_OK = 1,
        STATUS_ERROR = 2,
        STATUS_ERRORS = 3,
        STATUS_WYSTAW_MM = 4,
        STATUS_WARNING = 5;

    const TYP_WZ = 1,
        TYP_PZ = 2;

    const ZAMOWIENIE_OD_KLIENTOW = 16,
        ZAMOWIENIE_DO_DOSTAWCOW = 15;

    /**
     * @throws Twig_Error_Loader
     * @throws Twig_Error_Runtime
     * @throws Twig_Error_Syntax
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function indexAction()
    {
        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();


        if (isset($_POST['magazynGlowny'])) {
            $magazynGlowny = $_POST['magazynGlowny'];
        } else {
            $magazynGlowny = 87;
        }

        if (isset($_POST['magazynPomocniczy'])) {
            $magazynPomocniczy = $_POST['magazynPomocniczy'];
        } else {
            $magazynPomocniczy = 0;
        }

        $sprzedazWmagazynie = [];
        $filterName = '';
        $filterSymbol = '';
        $magazynyIds = [$magazynGlowny, $magazynPomocniczy];
        $docTypesIds = [2, 21];
        $towary = [];
        $today = new DateTime('now');
        $dateFrom = (isset($_POST['dateFrom'])) ? $_POST['dateFrom'] : $today->format('Y-m-d');
        $dateTo = (isset($_POST['dateTo'])) ? $_POST['dateTo'] : $today->modify('+7 days')->format('Y-m-d');
        $grupa = (isset($_POST['grupa'])) ? $_POST['grupa'] : 0;
        $cecha = (isset($_POST['cecha'])) ? $_POST['cecha'] : 0;
        $plusSale = (isset($_POST['plusSale']) && $_POST['plusSale'] = "on") ? 1 : 0;


        if (isset($_POST['sMagazyny'])) {
            $magazynyIds = array_merge($magazynyIds, $_POST['sMagazyny']);
        }
        if (isset($_POST['sTypy'])) {
            $docTypesIds = $_POST['sTypy'];
        }

        $where = '';


        if ($grupa > 0) {
            $where .= "AND t.tw_IdGrupa = " . $_POST['grupa'] . " ";
        }


        //disabled cause it's multi choice and join table fires many times

//        if($cecha > 0){
//           $where .= "AND c.cht_IdCecha = ".$_POST['cecha']." ";
//        }


        if (isset($_POST['nameText']) && strlen($_POST['nameText']) > 0) {
            $filterName = $_POST['nameText'];
            if ($_POST['nameHow'] == 1) {
                $where .= "AND t.tw_Nazwa LIKE '%" . $_POST['nameText'] . "%'";
            } elseif ($_POST['nameHow'] == 2) {
                $where .= "AND t.tw_Nazwa LIKE '" . $_POST['nameText'] . "%'";
            }
        }
        if (isset($_POST['symbolText']) && strlen($_POST['symbolText']) > 0) {
            $filterSymbol = $_POST['symbolText'];
            if ($_POST['symbolHow'] == 1) {
                $where .= "AND t.tw_Symbol LIKE '%" . $_POST['symbolText'] . "%'";
            } elseif ($_POST['symbolHow'] == 2) {
                $where .= "AND t.tw_Symbol LIKE '" . $_POST['symbolText'] . "%'";
            }
        }

        if (isset($_POST['renderTable']) && $_POST['renderTable'] == 1) {
            $objects = $pdo->query("SELECT t.tw_Id, t.tw_Nazwa, t.tw_Symbol, s.st_MagId, s.st_Stan, s.st_StanRez, s.st_TowId
                                    FROM dbo.tw__Towar t 
                                    LEFT JOIN dbo.tw_Stan s ON t.tw_Id = s.st_TowId 
                                    WHERE s.st_MagId IN(" . implode(',', $magazynyIds) . ") " . $where . " ORDER BY t.tw_Nazwa ");


            $objects = $objects->fetchAll();


            $objectsIds = [];
            foreach ($objects as $object) {
                $objectsIds[] = $object['tw_Id'];
            }


            if (count($objectsIds) > 0) {
                $pozycje = $pdo->query("SELECT p.ob_TowId, p.ob_IloscMag, d.dok_MagId 
                                          FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          WHERE d.dok_Typ IN(" . implode(',', $docTypesIds) . ") AND d.dok_DataWyst BETWEEN '$dateFrom' AND '$dateTo' AND d.dok_MagId IN(" . implode(',', $magazynyIds) . ") ");

                $pozycje = $pozycje->fetchAll();


                $sprzedaz = [];

                $sprzedazWmagazynie = [];

                foreach ($pozycje as $pozycja) {
                    if (in_array($pozycja['ob_TowId'], $objectsIds)) {
                        if (!array_key_exists($pozycja['ob_TowId'], $sprzedaz)) {
                            $sprzedaz[$pozycja['ob_TowId']] = [];
                        }
                        if (!array_key_exists($pozycja['dok_MagId'], $sprzedaz[$pozycja['ob_TowId']])) {
                            $sprzedaz[$pozycja['ob_TowId']][$pozycja['dok_MagId']] = 0;
                        }
                        if (!array_key_exists($pozycja['dok_MagId'], $sprzedazWmagazynie)) {
                            $sprzedazWmagazynie[$pozycja['dok_MagId']] = 0;
                        }
                        $sprzedaz[$pozycja['ob_TowId']][$pozycja['dok_MagId']] += $pozycja['ob_IloscMag'];
                        $sprzedazWmagazynie[$pozycja['dok_MagId']] += $pozycja['ob_IloscMag'];
                    }
                }
            }


            $final = [];
            $sprzedazWedlugSymbolu = [];

            foreach ($objects as $object) {
                $towarId = $object['tw_Id'];

                if (!array_key_exists($towarId, $towary)) {
                    $towary[$towarId]['id'] = $object['tw_Id'];
                    $towary[$towarId]['nazwa'] = $object['tw_Nazwa'];
                    $towary[$towarId]['symbol'] = $object['tw_Symbol'];
                    $towary[$towarId]['magazyny'] = [];
                    $towary[$towarId]['sumaSprzedaz'] = 0;
                    $final[$object['tw_Symbol']]['sprzedaz'] = 0;
                    $final[$object['tw_Symbol']]['renament'] = 0;
                    $final[$object['tw_Symbol']]['nazwa'] = $object['tw_Nazwa'];
                }
                $towary[$towarId]['magazyny'][$object['st_MagId']]['stan'] = $object['st_Stan'] - $object['st_StanRez'];

                $towary[$towarId]['magazyny'][$object['st_MagId']]['sprzedaz'] = (isset($sprzedaz[$object['tw_Id']][$object['st_MagId']])) ? $sprzedaz[$object['tw_Id']][$object['st_MagId']] : 0;

                if ($towary[$towarId]['magazyny'][$object['st_MagId']]['sprzedaz'] > 0) {
                    $final[$object['tw_Symbol']]['sprzedaz'] += $towary[$towarId]['magazyny'][$object['st_MagId']]['sprzedaz'];
                    $towary[$towarId]['sumaSprzedaz'] += $towary[$towarId]['magazyny'][$object['st_MagId']]['sprzedaz'];
                }
            }


            $objects = null;


            if ($grupa > 0) {
                $date = new DateTime($dateTo);
                $dateStringForQuantity = $date->format("Ymd");

                $sumStan = $pdo->query("select t.tw_id, t.tw_symbol, t.tw_nazwa, t.tw_JednMiary, t.tw_IdGrupa,
                         sum(A.mr_ilosc-isnull(R.mr_ilosc,0)) AS ilosc,
                         W.mw_cena as cena,  sum(dbo.fnInsMul( (A.mr_ilosc-isnull(R.mr_ilosc,0))  , W.mw_cena, 2 ))  as wartosc,  t.tw_IdVatSp, t.tw_Rodzaj, max(a.mr_id) mr_id, max(a.mr_data) mr_data
                         from 	dok_magruch A
                         inner join tw__towar T on A.mr_TowId = T.tw_Id
                         inner join vwDokMagWart W on A.mr_SeriaId = W.mw_SeriaId
                         left join ((select isnull( sum( C.mr_ilosc ), 0 ) mr_ilosc, C.mr_doId from dok_magruch C where C.mr_data<='$dateStringForQuantity' group by C.mr_doId)) R on R.mr_DoId = A.mr_id
                         where 	W.mw_pozid in
                         (SELECT TOP 1 T.mw_pozid  FROM vwDokMagWart T  WHERE T.mw_SeriaId = W.mw_seriaid and T.mw_data<='$dateStringForQuantity'
                          ORDER BY mw_data DESC, mw_pozid DESC)
                          and A.mr_TowId IN (" . implode(',', array_unique($objectsIds)) . ")
                          AND A.mr_magid IN (" . implode(',', $magazynyIds) . ")
                          and A.mr_data<='$dateStringForQuantity' and  A.mr_ilosc > isnull(R.mr_ilosc,0)
                          group by t.tw_id, t.tw_symbol, t.tw_nazwa, t.tw_JednMiary, t.tw_IdGrupa,  W.mw_cena,  t.tw_IdVatSp, t.tw_Rodzaj
");
                $sumStan = $sumStan->fetchAll();


                foreach ($sumStan as $sum) {
                    $final[$sum['tw_symbol']]['renament'] += $sum['ilosc'];
                }


                $spreadsheet = new Spreadsheet();

                $sheet = $spreadsheet->getActiveSheet();

                $sheet->setCellValue("A1", "symbol");
                $sheet->setCellValue("B1", "nazwa");
                $sheet->setCellValue("C1", "renament - $dateTo");
                $sheet->setCellValue("D1", "sprzedaz - $dateFrom - $dateTo");

                ksort($final);

                $i = 2;
                foreach ($final as $symbol => $row) {
                    $sheet->setCellValue("A$i", $symbol);
                    $sheet->setCellValue("B$i", $row['nazwa']);
                    $sheet->setCellValue("C$i", $row['renament']);
                    $sheet->setCellValue("D$i", $row['sprzedaz']);
                    $i++;
                }

                $writer = new Xlsx($spreadsheet);
                $writer->save("xlsx/$dateFrom.xlsx");
            }

            //echo "<pre>";
            //die(var_dump($final));

//        echo'<pre>';
//        die(var_dump($towary));
        }

        $magazyny = $pdo->query("SELECT m.* FROM dbo.sl_Magazyn m ");
        $magazyny = $magazyny->fetchAll();

        $magazynyNazwy = [];

        foreach ($magazyny as $magazyn) {
            $magazynyNazwy[$magazyn['mag_Id']] = $magazyn['mag_Symbol'];
        }

        $cechy = $pdo->query("SELECT c.* FROM dbo.sl_CechaTw c");
        $cechy = $cechy->fetchAll();

        $grupy = $pdo->query("SELECT g.* FROM dbo.sl_GrupaTw g");
        $grupy = $grupy->fetchAll();


        $filters = [
            'magazynyIds' => $magazynyIds,
            'nameText' => $filterName,
            'nameHow' => (isset($_POST['nameHow'])) ? $_POST['nameHow'] : 1,
            'symbolText' => $filterSymbol,
            'symbolHow' => (isset($_POST['symbolHow'])) ? $_POST['symbolHow'] : 1,
            'magazynGlowny' => $magazynGlowny,
            'magazynPomocniczy' => $magazynPomocniczy,
            'docTypesIds' => $docTypesIds,
            'dateFrom' => $dateFrom,
            'dateTo' => $dateTo,
            'grupa' => $grupa,
            'cecha' => $cecha,
            'plusSale' => $plusSale,
        ];


        if ($plusSale > 0) {
            foreach ($towary as $key => $towar) {
                $stay = false;

                foreach ($towar['magazyny'] as $magKey => $magazyn) {
                    if ($magazyn['sprzedaz'] > 0 && $magKey != $magazynGlowny && $magKey != $magazynPomocniczy) {
                        $stay = true;
                    }
                }

                if (false == $stay) {
                    unset($towary[$key]);
                }
            }
        }

        echo $twig->render('orders/index.html.twig', ['towary' => $towary,
            'magazynyIds' => $magazynyIds,
            'sprzedazWmagazynie' => $sprzedazWmagazynie,
            'dTypy' => $this->getDocTypes(),
            'filters' => $filters,
            'magazyny' => $magazyny,
            'magazynyNazwy' => $magazynyNazwy,
            'cechy' => $cechy,
            'magazynGlowny' => $magazynGlowny,
            'magazynPomocniczy' => $magazynPomocniczy,
            'grupy' => $grupy,
        ]);
    }

    public function getDataForMMAction()
    {
        $return = [];

        if (!array_key_exists('data', $_POST)) {
            $return[0]['status'] = self::STATUS_ERROR;
            $return[0]['error'] = "Należy podać dane";
            echo json_encode($return);
            exit;
        }

        $data = $_POST['data'];
        $magazynFrom = $_POST['magazynFrom'];
        $magazynFromHelp = $_POST['magazynFromHelp'];
        
        foreach ($data as $magazynTo => $pozycje) {
            $return[$magazynTo] = $this->wystawMM($magazynFrom, $magazynTo, $pozycje, $magazynFromHelp);
        }

        //var_dump($return );
        //var_dump(json_encode($return) );

        echo json_encode($return);
        exit;
    }

    private function wystawMM($magazynFromId, $magazynToId, $positionsToNewDoc, $magazynFromHelp)
    {

        $this->checkPositionsOnMainMagazine($magazynFromId, $positionsToNewDoc, $magazynFromHelp);

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $mm = $Subiekt->SuDokumentyManager->DodajMM();

        try {
            $mm->MagazynNadawczyId = intval($magazynFromId);
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn nadawczy"];
        }

        try {
            $magazynToId = $this->PobierzBuforDlaMagazynu($magazynToId);
            $mm->MagazynOdbiorczyId = intval($magazynToId);
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn odbiorczy"];
        }

        $errors = [];
        $warnings = [];
        foreach ($positionsToNewDoc as $position) {
            try {
                $towar = $Subiekt->TowaryManager->WczytajTowarWg(intval($position['towarId']), 5);
            } catch (Exception $e) {
                return ['status' => self::STATUS_ERROR, 'error' => __LINE__ . ": " . $e->getMessage()];
            }
            $stan = $this->SprawdzStanMagazynowy($towar->Identyfikator, $magazynFromId);

            $stanDostepne = $stan['st_Stan'] - $stan['st_StanRez'];

            if (intval($stanDostepne < $position['ilosc'])) {
                $ilosc = $stanDostepne;

                if ($ilosc > 0) {
                    $warnings[] = iconv("Windows-1250", "UTF-8", $towar->Nazwa) . " (" . $towar->Symbol . ") dodano " . $stanDostepne . " z " . $position['ilosc'] . " - brak na magazynie głównym";
                }
            } else {
                $ilosc = $position['ilosc'];
            }

            if ($ilosc > 0) {
                $oPoz = $mm->Pozycje->Dodaj(intval($towar->Identyfikator));
                $oPoz->IloscJm = floatval($ilosc);
            } else {
                $warnings[] = iconv("Windows-1250", "UTF-8", $towar->Nazwa) . " (" . $towar->Symbol . ") nie dodano - brak na magazynie głównym";
            }

//            $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
//            $oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
        }

        if (count($errors) > 0) {
            return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
        }

        try {
            //$mm->StatusDokumentu = 0;

            $mm->Zapisz();

            $mm->Zamknij();
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => __LINE__ . ": " . $e->getMessage()];
        }


        $Subiekt->Zakoncz();


        return ['status' => self::STATUS_OK, 'warnings' => $warnings];
    }

    private function wystawMMFromHelp($magazynFromId, $magazynToId, $positionsToNewDoc)
    {
        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $mm = $Subiekt->SuDokumentyManager->DodajMM();

        try {
            $mm->MagazynNadawczyId = intval($magazynFromId);
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn nadawczy"];
        }

        try {
            $magazynToId = intval($magazynToId);
            $mm->MagazynOdbiorczyId = intval($magazynToId);
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn odbiorczy"];
        }

        $errors = [];
        $warnings = [];
        foreach ($positionsToNewDoc as $position) {
            try {
                $towar = $Subiekt->TowaryManager->WczytajTowarWg(intval($position['towarId']), 5);
            } catch (Exception $e) {
                return ['status' => self::STATUS_ERROR, 'error' => __LINE__ . ": " . $e->getMessage()];
            }
            $stan = $this->SprawdzStanMagazynowy($towar->Identyfikator, $magazynFromId);

            $stanDostepne = $stan['st_Stan'] - $stan['st_StanRez'];

            if (intval($stanDostepne < $position['ilosc'])) {
                $ilosc = $stanDostepne;

                if ($ilosc > 0) {
                    $warnings[] = iconv("Windows-1250", "UTF-8", $towar->Nazwa) . " (" . $towar->Symbol . ") dodano " . $stanDostepne . " z " . $position['ilosc'] . " - brak na magazynie głównym";
                }
            } else {
                $ilosc = $position['ilosc'];
            }

            if ($ilosc > 0) {
                $oPoz = $mm->Pozycje->Dodaj(intval($towar->Identyfikator));
                $oPoz->IloscJm = floatval($ilosc);
            } else {
                $warnings[] = iconv("Windows-1250", "UTF-8", $towar->Nazwa) . " (" . $towar->Symbol . ") nie dodano - brak na magazynie głównym";
            }

//            $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
//            $oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
        }

        if (count($errors) > 0) {
            return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
        }

        try {
            //$mm->StatusDokumentu = 0;

            $mm->Zapisz();

            $mm->Zamknij();
        } catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => __LINE__ . ": " . $e->getMessage()];
        }


        $Subiekt->Zakoncz();


        return ['status' => self::STATUS_OK, 'warnings' => $warnings];
    }

    private function checkPositionsOnMainMagazine($magazynFromId, $positionsToNewDoc, $magazynFromHelp)
    {
        $newPositions = [];
        foreach ($positionsToNewDoc as $position) {

            $stan = $this->SprawdzStanMagazynowy($position['towarId'], $magazynFromId);

            $stanDostepne = $stan['st_Stan'] - $stan['st_StanRez'];

            if (intval($stanDostepne < $position['ilosc'])) {
                $newPositions[] = [
                    "towarId" => $position['towarId'],
                    "ilosc" => $position['ilosc'] - $stanDostepne
                ];
            }
        }

        if(count($newPositions) > 0){
            $this->wystawMMFromHelp($magazynFromHelp, $magazynFromId, $newPositions);
        }
    }

    private function getDocTypes()
    {
        $docTypes[1] = ['short' => 'FS', 'name' => 'Faktura VAT sprzedaży', 'id' => 2];
        //$docTypes[2] = ['short' => 'FSzal', 'name' => 'Faktura sprzedaży zaliczkowa', 'id' => ];
        //$docTypes[3] = ['short' => 'FSz', 'name' => 'Faktura sprzedaży zbiorcza', 'id' => ];
        $docTypes[4] = ['short' => 'FM', 'name' => 'Faktura sprzedaży marżą', 'id' => 62];
        $docTypes[5] = ['short' => 'RS', 'name' => 'Rachunek sprzedaży', 'id' => 4];
        $docTypes[6] = ['short' => 'KFS', 'name' => 'Korekta faktury VAT sprzedaży', 'id' => 6];
        //$docTypes[7] = ['short' => 'KFSn', 'name' => 'Korekta faktury sprzedaży do nieistniejącego', 'id' => ];
        //$docTypes[8] = ['short' => 'KFSzc', 'name' => 'Korekta faktury sprzedaży zaliczkowej', 'id' => ];
        $docTypes[9] = ['short' => 'KFM', 'name' => 'Korekta faktury VAT marżą', 'id' => 67];
        //$docTypes[10] = ['short' => 'KFMn', 'name' => 'Korekta faktury marża do nieistniejącego', 'id' => ];
        //$docTypes[11] = ['short' => 'FSd', 'name' => 'Faktura sprzedaży detaliczna', 'id' => ];
        $docTypes[12] = ['short' => 'PA', 'name' => 'Paragon', 'id' => 21];
        //$docTypes[13] = ['short' => 'PAi', 'name' => 'Paragon imienny', 'id' => ];
        //$docTypes[14] = ['short' => 'PAf', 'name' => 'Paragoon fiskalny', 'id' => ];
        //$docTypes[15] = ['short' => 'PAk', 'name' => 'Paragon odebrany z kasy', 'id' => ];
        $docTypes[16] = ['short' => 'ZW', 'name' => 'Zwrot ze sprzedaży detalicznej', 'id' => 14];
        //$docTypes[17] = ['short' => 'ZWn', 'name' => 'Zwrot do nieistniejącego', 'id' => ];


        return $docTypes;
    }

    private function SprawdzStanMagazynowy($idTowaru, $magazynId)
    {
        $db = new connectionController;
        $pdo = $db->getPdo();

        $stan = $pdo->query("SELECT * FROM dbo.tw_Stan WHERE st_MagId = " . $magazynId . " AND st_TowId = " . $idTowaru . " ");
        $stan = $stan->fetch();

        return $stan;
    }

    private function PobierzBuforDlaMagazynu($magazynId)
    {
        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.zzzRobmar_magazyny_kontrahentow WHERE magazynId=" . $magazynId . " ");
        $id = $id->fetch();

        return $id['buforId'];
    }

    private function print_mem()
    {
        /* Currently used memory */
        $mem_usage = memory_get_usage();

        /* Peak memory usage */
        $mem_peak = memory_get_peak_usage();

        echo 'The script is now using: <strong>' . round($mem_usage / 1024 / 1024) . 'MB</strong> of memory.<br>';
        echo 'Peak usage: <strong>' . round($mem_peak / 1024 / 1024) . 'MB</strong> of memory.<br><br>';
    }
}
