<?php

include 'requires.php';


class csvController
{
    const ZAM_NIEZREALIZOWANE = 5,
        ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI = 6,
        ZAM_NIEZREALIZOWANE_Z_REZERWACJA = 7;

    const STATUS_EX_NIE_ZREALIZOWANE = 0,
          STATUS_EX_ZREALIZOWANE_CZESCIOWO = 1,
          STATUS_EX_ZREALIZOWANE_FS_ZAL_POSREDNIA = 8;

    const ZAMOWIENIE_OD_KLIENTOW = 16,
        ZAMOWIENIE_DO_DOSTAWCOW = 15,
        WYDANIE_ZEWNETRZNE = 11,
        PRZESUNIECIE_MIEDZYMAGAZYNOWE = 9,
        PRZYJECIE_ZEWNETRZNE = 10;

    const PODTYP_ZAMOWIENIE_ZALICZKOWE = 1;

    public function indexAction()
    {

        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();

        $orders = [];
        $filters = [];

        $docType = self::ZAMOWIENIE_OD_KLIENTOW;
        $magId = 0;
        $konId = 0;
        $pzMagIds = 0;

        if(isset($_POST['renderTable']) && $_POST['renderTable'] == 1){

            $magId = $_POST['magazine'];
            $pzMagIds = $_POST['pzMagazines'];
            // $konId = $_POST['client'];

        }

        echo $twig->render('csv/index.html.twig', [
            'orders' => $this->getDocs([$docType], $magId, $konId),
            'pzs' => $this->getDocs([self::PRZYJECIE_ZEWNETRZNE, self::PRZESUNIECIE_MIEDZYMAGAZYNOWE], $pzMagIds, $konId),
            'magazines' => $this->getMagazines(),
         //dodany27082020  'clients' => $this->getClients(),
            'filters' => $this->getFilters()
            ]);

    }

    public function generateCsvAction(){


        $ordersIds = (isset($_POST['orders'])) ? $_POST['orders'] : [];
        $pzsIds = (isset($_POST['pzs'])) ? $_POST['pzs'] : [];

        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();

        $orders = [];
        $filters = [];

        $magId = $_POST['magazine'];
        $konId = $_POST['client'];

        $pzTowary = $this->sumSelectedPz($pzsIds);

        if(count($ordersIds) > 0){
            $checkedOrders = $pdo->query("SELECT d.*, k.kh_Symbol, k.kh_Id, 
                                            ah.*, ph.*, a.*, p.pa_KodPanstwaUE as kodUE, e.*, pw.pwd_Liczba01,pw2.pwd_Fk01 FROM dbo.dok__Dokument d 
                                            LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
                                            LEFT JOIN dbo.adr_Historia ah ON d.dok_AdresDostawyAdreshId = ah.adrh_Id
                                            LEFT JOIN dbo.sl_Panstwo ph ON ph.pa_Id = ah.adrh_IdPanstwo
                                            LEFT JOIN dbo.adr__Ewid a ON d.dok_PlatnikId = a.adr_IdObiektu AND a.adr_TypAdresu = 1
                                            LEFT JOIN dbo.sl_Panstwo p ON p.pa_Id = a.adr_IdPanstwo
                                            LEFT JOIN dbo.adr_Email e ON e.am_IdAdres = a.adr_Id AND e.am_Podstawowy = 1
                                            LEFT JOIN dbo.pw_Dane pw ON pw.pwd_IdObiektu = k.kh_Id AND pw.pwd_TypObiektu=-12
											LEFT JOIN dbo.pw_Dane pw2 ON pw2.pwd_IdObiektu = d.dok_Id AND pw2.pwd_TypObiektu=-8
                                            WHERE d.dok_Id IN(".implode(',', $ordersIds).") ORDER BY CASE WHEN pw.pwd_Liczba01 IS NULL THEN 1 ELSE 0 END, pw.pwd_Liczba01");
            $checkedOrders = $checkedOrders->fetchAll();
//											LEFT JOIN dbo.pw_Dane pw2 ON pw2.pwd_IdObiektu = d.dok_Id     
//,pw2.pwd_Fk01
            
            $fp = fopen('file.csv', 'w');

            $line = 0;
            $aData = [];

            $this->setCsvHeaders($aData);

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();


            foreach ($checkedOrders as $order) {

                $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol, t.tw_Nazwa FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokHanId = ".$order['dok_Id']." ");
                $pozycje = $pozycje->fetchAll();

                // jezeli zamowienie zaliczkowe pobieramy wydane wczesniej pozycje
                if($order['dok_Podtyp'] == self::PODTYP_ZAMOWIENIE_ZALICZKOWE){
                    $pozycjeWydane = $this->getPozycjeWydane($order['dok_Id']);
                }

        $Subiekt->MagazynId = intval(226); //226 - Arvato kontraktacje
		        $zk = $Subiekt->SuDokumentyManager->DodajZK();
		try{
            $zk->KontrahentId = intval($order['dok_OdbiorcaId']);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
        }
			if (!empty($order['dok_AdresDostawyAdreshId'])){
			$zk->AdresDostawyId = intval($order['dok_AdresDostawyAdreshId']);
			}
		$zk->Uwagi = $order['pwd_Fk01']." - " .$order['dok_Uwagi'] ;
		$zk->NumerOryginalny = $order['dok_NrPelny'];
				
	//$zk->PoleWlasne("KURIER");
		//die(var_dump($test));
					//$test $zk->PoleWlasne("KURIER") = intval($order['pwd_Fk01']);
			//$tmpNrZamowienia = 0;
			//$tmpLpPozycja = 0;
                foreach($pozycje as $pozycja){
                    $tmpIlosc = 0;
                    if(array_key_exists($pozycja['tw_Symbol'], $pzTowary)){
                        if($pzTowary[$pozycja['tw_Symbol']] > 0){

                            // jezeli zamowienie zaliczkowe odejmujemy wydane wczesniej pozycje
                             if($order['dok_Podtyp'] == self::PODTYP_ZAMOWIENIE_ZALICZKOWE){
                                 if(array_key_exists($pozycja['tw_Symbol'], $pozycjeWydane)){
                                     $pozycja['ob_Ilosc'] -= $pozycjeWydane[$pozycja['tw_Symbol']];
                                 }
                             }


                            if($pzTowary[$pozycja['tw_Symbol']] >= $pozycja['ob_Ilosc']){
                                $tmpIlosc = $pozycja['ob_Ilosc'];
                                $pzTowary[$pozycja['tw_Symbol']] -= $pozycja['ob_Ilosc'];
                            }else{
                                $tmpIlosc = $pzTowary[$pozycja['tw_Symbol']];
                                $pzTowary[$pozycja['tw_Symbol']] = 0;

                                $warnings[] = "zrealizowano tylko czesc zamowienia";

                            }

			
                            if($tmpIlosc > 0){
                                $line++;


									$oPoz = $zk->Pozycje->Dodaj(intval($pozycja['ob_TowId']));
									$oPoz->IloscJm = floatval($tmpIlosc);
									$oPoz->CenaNettoPrzedRabatem = floatval($pozycja['ob_CenaNetto']);
									$oPoz->RabatProcent = floatval($pozycja['ob_Rabat']);
/*							$now = new \DateTime('now');
									
									
									if  ($tmpNrZamowienia = $pozycja['dok_NrPelny'])
									{
										$tmpLpPozycja++;
									}
									else
									{
										$tmpLpPozycja = 1;
									}
                                $aData[$line][0] = $pozycja['dok_NrPelny'];
                                $aData[$line][1] = $now->format('Y-m-d');
                                $aData[$line][2] = '5';
                                $aData[$line][3] = 'parcels';

                                $this->setClientAddress($line, $order, $aData);

                                $aData[$line][11] = '';
                                $aData[$line][12] = '';
                                $aData[$line][13] = '';
                                $aData[$line][14] = '';
                                $aData[$line][15] = '';
                                $aData[$line][16] = '';
                                //var_dump($pozycja['tw_Symbol']." - ".$pozycja['ob_Ilosc']);
                                $aData[$line][18] = $tmpLpPozycja;
                                //$aData[$line][19] = $order['dok_Uwagi'];
                                $aData[$line][20] = $pozycja['tw_Nazwa'];
                                $aData[$line][21] = $pozycja['tw_Symbol'];
                                $aData[$line][22] = floatval($tmpIlosc);
                                $aData[$line][23] = (strpos(strtolower($pozycja['dok_Uwagi']), "pobranie") !== false) ? 1 : 0;

                                ksort($aData[$line]);
								$tmpNrZamowienia = $pozycja['dok_NrPelny'];
								
								*/
                            }

                        }else{
                            $errors[] = "towar ma zerowa ilosc";
                        }

                    }else{
                        $errors[] = "brak symbolu w pztowary";
                    }


                }
//            var_dump($warnings);
//            var_dump($errors);
//            die(var_dump($zk->Pozycje->Liczba));
							
							if ( $zk->Pozycje->Liczba > 0 )
							{
							try{
										$zk->Zapisz();
										//$noweId = $zk->Identyfikator;
										//$zk->Zamknij();
										//$Subiekt->MagazynId = intval(211);
										//$zk1 = $Subiekt->SuDokumentyManager->WczytajDokument($noweId);
										//die(var_dump($zk1->Identyfikator)) ;
										$Subiekt->UstawPoleWlasne($zk , "KURIER" , intval($order['pwd_Fk01']) );
										//$zk1->Zapisz();
										$zk->Zamknij();
									}catch (Exception $e){
										die(var_dump($e->getMessage()));
									}
									//$this->PowiazDokumenty($noweId, $staryId, $staryNumer);
									//return ['status' => self::STATUS_OK];
							}
						else
						{
							try{
										//$zk->Zapisz();
										//$noweId = $zk->Identyfikator;
										$zk->Zamknij();
									}catch (Exception $e){
										return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
									}
									//$this->PowiazDokumenty($noweId, $staryId, $staryNumer);
									//return ['status' => self::STATUS_OK];
								
							}
						}
															$Subiekt->Zakoncz();

			
//            var_dump($warnings);
//            var_dump($errors);
//            die(var_dump($pzTowary));

            $csv=$this->prepareCSV($aData, ";");

            $nazwa_csv='export_'.date('d_m_Y_G_i_s');

            $uchwyt = fopen('csv/'.$nazwa_csv.'.csv', 'w');
            fwrite($uchwyt, $csv);

            fclose($fp);

            echo $twig->render('csv/index.html.twig', [
                'orders' => $this->getDocs([self::ZAMOWIENIE_OD_KLIENTOW], $magId, $konId),
                'pzs' => $this->getDocs([self::PRZYJECIE_ZEWNETRZNE, self::PRZESUNIECIE_MIEDZYMAGAZYNOWE], $magId, $konId),
                'selectedPzs' => [],
                'magazines' => $this->getMagazines(),
        //dodany27082020   'clients' => $this->getClients(),
                'filters' => $this->getFilters(),
                'success' => "Wygenerowano plik .csv",
                'csv' => $nazwa_csv
            ]);
            exit();
        }

        echo $twig->render('csv/index.html.twig', [
            'orders' => $this->getDocs([self::ZAMOWIENIE_OD_KLIENTOW], $magId, $konId),
            'magazines' => $this->getMagazines(),
         //dodany27082020   'clients' => $this->getClients(),
            'filters' => $this->getFilters(),
            'pzs' => $this->getDocs([self::PRZYJECIE_ZEWNETRZNE, self::PRZESUNIECIE_MIEDZYMAGAZYNOWE], $magId, $konId),
            'selectedPzs' => isset($_POST['pzs']) ? $_POST['pzs'] : [],
            'error' => "Nie znaleziono żadnych zamówień",
        ]);

    }

    private function getPozycjeWydane($dokId){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $wzs = $pdo->query("SELECT d.* FROM dbo.dok__Dokument d 
                                            WHERE d.dok_Typ = ".self::WYDANIE_ZEWNETRZNE." AND d.dok_DoDokId = ".$dokId." ");
        $wzs = $wzs->fetchAll();

        $pzTowary = [];

        foreach ($wzs as $wz) {

            $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokMagId = " . $wz['dok_Id'] . " ");
            $pozycje = $pozycje->fetchAll();

            foreach ($pozycje as $pozycja) {
                if (!array_key_exists($pozycja["tw_Symbol"], $pzTowary)) {
                    $pzTowary[$pozycja["tw_Symbol"]] = 0;
                }
                $pzTowary[$pozycja["tw_Symbol"]] += $pozycja["ob_Ilosc"];
            }

        }

        return $pzTowary;

    }

    private function sumSelectedPz($pzsIds){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $pzTowary = [];

        if(count($pzsIds) > 0) {
            $selectedPzs = $pdo->query("SELECT d.* FROM dbo.dok__Dokument d 
                                            WHERE d.dok_Id IN(" . implode(',', $pzsIds) . ") ");
            $selectedPzs = $selectedPzs->fetchAll();

            foreach ($selectedPzs as $pz) {

                $pozycje = $pdo->query("SELECT p.*, d.*, t.tw_Symbol FROM dbo.dok_Pozycja p 
                                          LEFT JOIN dbo.dok__Dokument d ON p.ob_DokHanId = d.dok_Id
                                          LEFT JOIN dbo.tw__Towar t ON t.tw_Id = p.ob_TowId
                                          WHERE p.ob_DokMagId = " . $pz['dok_Id'] . " ");
                $pozycje = $pozycje->fetchAll();

                foreach ($pozycje as $pozycja) {
                    if (!array_key_exists($pozycja["tw_Symbol"], $pzTowary)) {
                        $pzTowary[$pozycja["tw_Symbol"]] = 0;
                    }
                    $pzTowary[$pozycja["tw_Symbol"]] += $pozycja["ob_Ilosc"];
                }

            }
        }

        return $pzTowary;

    }

    private function setCsvHeaders(&$aData){
        $aData[0][1] = 'OrderID';
        $aData[0][2] = 'SendDate';
        $aData[0][3] = 'SendMethodCode';
        $aData[0][4] = 'PackMethodCode';
        $aData[0][5] = 'ClientName';
        $aData[0][6] = 'ClientCountryCode';
        $aData[0][7] = 'ClientCity';
        $aData[0][8] = 'ClientPostCode';
        $aData[0][9] = 'ClientStreet';
        $aData[0][10] = 'ClientHouseNum';
        $aData[0][11] = 'ClientFlatNum';
        $aData[0][12] = 'PaczkawRuchuCity';
        $aData[0][13] = 'PaczkawRuchuStreet';
        $aData[0][14] = 'PaczkawRuchuClientFirstName';
        $aData[0][15] = 'PaczkawRuchuClientLastName';
        $aData[0][16] = 'PaczkawRuchuPSDcode';
        $aData[0][17] = 'PaczkomatyInpost';
        $aData[0][18] = 'ClientEmail';
        $aData[0][19] = 'ClientPhone';
        $aData[0][20] = 'Comment';
        $aData[0][21] = 'ProductEAN';
        $aData[0][22] = 'ProductCount';
        $aData[0][23] = 'Pobranie';
    }

    private function setClientAddress($line, $order, &$aData){

        if($order['dok_AdresDostawyAdreshId'] > 0){

            $aData[$line][4] = (strlen($order['adrh_NazwaPelna']) > 0) ? $order['adrh_NazwaPelna'] : $order['adrh_Nazwa'];
            $aData[$line][5] = $order['pa_KodPanstwaUE'];
            //$aData[$line][5] = "PL";
            $aData[$line][6] = $order['adrh_Miejscowosc'];
            $aData[$line][7] = $order['adrh_Kod'];
            $aData[$line][8] = $order['adrh_Ulica'];
            $aData[$line][9] = $order['adrh_NrDomu'];
            $aData[$line][10] = $order['adrh_NrLokalu'];
            $aData[$line][19] = $order['adrh_Telefon'];


        }
        else{

            $aData[$line][4] = (strlen($order['adr_NazwaPelna']) > 0) ? $order['adr_NazwaPelna'] : $order['adr_Nazwa'];
            $aData[$line][5] = $order['kodUE'];
            $aData[$line][6] = $order['adr_Miejscowosc'];
            $aData[$line][7] = $order['adr_Kod'];
            $aData[$line][8] = $order['adr_Ulica'];
            $aData[$line][9] = $order['adr_NrDomu'];
            $aData[$line][10] = $order['adr_NrLokalu'];
            $aData[$line][19] = $order['adr_Telefon'];

        }

    }

    private function getDocs($docTypes, $magIds, $konId = 0){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $andWhere = "";
        $orderBy = "ORDER BY d.dok_DataWyst";
	
		
		if(!is_array($magIds)){
			$magIds = explode(",", $magIds);
		}
	

        if(in_array(self::ZAMOWIENIE_OD_KLIENTOW, $docTypes)){
            $docStatuses = [self::ZAM_NIEZREALIZOWANE, self::ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI, self::ZAM_NIEZREALIZOWANE_Z_REZERWACJA];
            $docExStatuses = [self::STATUS_EX_NIE_ZREALIZOWANE, self::STATUS_EX_ZREALIZOWANE_CZESCIOWO, self::STATUS_EX_ZREALIZOWANE_FS_ZAL_POSREDNIA];
            $andWhere = "AND d.dok_Status IN(".implode(',', $docStatuses).") AND d.dok_StatusEx IN(".implode(',', $docExStatuses).")";
            $orderBy = "ORDER BY CASE WHEN pw.pwd_Liczba01 IS NULL THEN 1 ELSE 0 END, pw.pwd_Liczba01";
        }


        $orders = $pdo->query("SELECT d.dok_Id, d.dok_NrPelny, k.kh_Symbol, pw.pwd_Liczba01 FROM dbo.dok__Dokument d 
                                            LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
                                            LEFT JOIN dbo.pw_Dane pw ON pw.pwd_IdObiektu = k.kh_Id  AND pw.pwd_TypObiektu=-12
                                            WHERE d.dok_DataWyst > (GetDate()-365) and d.dok_MagId IN(".implode(',', $magIds).") AND d.dok_Typ IN(".implode(',', $docTypes).") ".$andWhere." ".$orderBy." ");
        $orders = $orders->fetchAll();

        // AND k.kh_Id = ".$konId."

        return $orders;

    }

    private function getFilters(){
        $filters = [
            'magazine' => (isset($_POST['magazine'])) ?  $_POST['magazine'] : 0,
            'pzMagazines' => (isset($_POST['pzMagazines'])) ?  $_POST['pzMagazines'] : 0,
            'client' => (isset($_POST['client'])) ?  $_POST['client'] : 0,
            'renderTable' => (isset($_POST['renderTable']) && $_POST['renderTable'] == 1) ?  1 : 0,
			];

        return $filters;
    }

    private function getMagazines(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $magazyny = $pdo->query("SELECT m.* FROM dbo.sl_Magazyn m ORDER BY m.mag_Nazwa");
        $magazyny = $magazyny->fetchAll();

        return $magazyny;

    }

    private function getClients(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $kontrahenci = $pdo->query('SELECT k.*, a.* FROM dbo.kh__Kontrahent k 
                        LEFT JOIN dbo.adr__Ewid a ON k.kh_Id=a.adr_IdObiektu AND a. adr_TypAdresu = 1');
        $kontrahenci = $kontrahenci->fetchAll();

        return $kontrahenci;
    }

    private function prepareCSV($aData, $sSeparator)
    {
        $aCSV = array();

        foreach($aData as $aRow) {
            $aCSV[] = implode($sSeparator, $aRow);
        }

        return implode("\n", $aCSV);
    }



}


?>
