'use strict';

(function (window, $, myFilters, magazyny) {
    window.OrdersApp = function ($wrapper) {

        this.$wrapper = $wrapper;

        this._inits();

        this._checkLimits();

        this.$wrapper.on(
            'click',
            '.new',
            this.alertIt.bind(this)
        );

        this.$wrapper.find('#test').on(
            'click',
            '.test',
            this.alertIt.bind(this)
        );

        this.$wrapper.on(
            'change',
            '.chInput',
            this.sumInputs.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#closeFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#openFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#wystawMM',
            this.wystawMM.bind(this)
        );

    };

    $.extend(window.OrdersApp.prototype, {

        alertIt: function (e) {
            e.preventDefault();
            alert("it's working");
        },

        toggleFilters: function (e) {
            e.preventDefault();
            $('#closeFilters, #openFilters, #filters').toggle();
        },
        sumInputs: function (e) {
            e.preventDefault();
            var self = e.currentTarget;

            var sumBy = $(self).data('class');
            var magazyn = $(self).data('magazyn');

            var sum = 0;
            $( ".input-" + sumBy ).each(function() {
                if($.isNumeric($(this).val())){
                    sum = sum + parseInt($(this).val());
                }
            });
            $(".sum[data-id=" + sumBy + "]").html(sum);

            var dostepne = parseInt($(".dostepne[data-id=" + sumBy + "]").html());
            var zamowione = parseInt($(".sum[data-id=" + sumBy + "]").html());

            $(".pozostale[data-id=" + sumBy + "]").html(dostepne - zamowione);

            var sumZamowiono = 0;

            $(".chInput[data-magazyn=" + magazyn + "]").each(function() {
                if($.isNumeric($(this).val())){
                    sumZamowiono = sumZamowiono + parseInt($(this).val());
                }
            });

            //var sumZamowiono = parseInt($(".sumZamowiono[data-id=" + magazyn + "]").html());

            var magazynLimit = $(".magazynLimit[data-id=" + magazyn + "]").html();

            if(parseInt(sumZamowiono) > parseInt(magazynLimit)){
                $(".magazynLimitWrapper[data-id=" + magazyn + "]").css('color', 'red');
            }else{
                $(".magazynLimitWrapper[data-id=" + magazyn + "]").css('color', 'black');
            }

            $(".sumZamowiono[data-id=" + magazyn + "]").html(sumZamowiono);

        },

        wystawMM: function(e){

            var data = {};

            $(".chInput").each(function () {

                if($(this).val() > 0){

                    if(!($(this).attr('data-magazyn') in data)){
                        data[$(this).attr('data-magazyn')] = [];
                    }

                    var towarId = $(this).attr('data-class');
                    var ilosc = $(this).val();

                    data[$(this).attr('data-magazyn')].push({'towarId': towarId, 'ilosc': ilosc});
                }


            });


            $('#wystawMM').prop('disabled', true);
            $('#wystawMMLoader').show();

            $.ajax({
                type: 'POST', url: 'orders.php?action=getDataForMM', dataType: 'json', data: {
                   data: data,
                    magazynFrom: $('#magazynGlowny').val(),
                    magazynFromHelp: $('#magazynPomocniczy').val()

                }
            }).done(function(resp) {


                $('#infoModalHeader').html('Zakończono proces wystawiania przesunięć magazynowych');


                var html = '';
                $.each( resp, function( key, value ) {
                    html += '<p style="font-weight: bold;">Dla magazynu ' + magazyny[key] + ':</p>';
                    if(value['status'] == 1){
                        $.each( value['warnings'], function( key1, value1 ) {
                            html += "<p>" + value1 + "</p>";
                        });
                    }
                    else if(value['status'] == 2){
                            html = "<p>" + value['error'] + "</p>";
                    }
                    else if(value['status'] == 3){
                        $.each( value['errors'], function( key1, value1 ) {
                            html += "<p>" + value1 + "</p>";
                        });
                    }
                });


                $('#infoModalContent').html(html);

            }).fail(function() {

                $('#infoModalHeader').html('Wystąpił nieznany błąd. Skontaktuj się z administratorem.');

            }).always(function() {
                $('#infoModal')
                    .modal('show')
                ;
                $('#wystawMM').prop('disabled', false);
                $('#wystawMMLoader').hide();
            });

        },

        _checkLimits: function (e) {
           
            document.querySelectorAll('.magazynLimit').forEach(function(element) {

                var qElement = $(element);

                var magazyn = qElement.data('id');

                var sumZamowiono = $(".sumZamowiono[data-id=" + magazyn + "]").html();

                var magazynLimit = $(".magazynLimit[data-id=" + magazyn + "]").html();

                if(parseInt(sumZamowiono) > parseInt(magazynLimit)){
                    $(".magazynLimitWrapper[data-id=" + magazyn + "]").css('color', 'red');
                }
            });
        },

        _inits: function (e) {
            $('.dropdown').dropdown();


            $('.chosen').chosen();


            $("#dateFrom").flatpickr({locale: "pl", defaultDate: myFilters.dateFrom});
            $("#dateTo").flatpickr({locale: "pl", defaultDate: myFilters.dateTo});

            jQuery.extend( jQuery.fn.dataTableExt.oSort, {
                "polish-string-asc" : function (s1, s2) {
                    return s1.localeCompare(s2);
                },

                "polish-string-desc" : function (s1, s2) {
                    return s2.localeCompare(s1);
                }
            } );

            var wHeight = window.innerHeight;

            var table = $('#dataTable').DataTable({
                responsive: false,
                fixedColumns: {
                    leftColumns: 4
                },
                scrollX: true,
                scrollY: (wHeight - 300) + "px",
                bPaginate: false,
                bLengthChange: false,
                bFilter: false,
                bInfo: false,
                bAutoWidth: false,
                // columnDefs: [{
                //     type: 'polish-string',
                //     targets: 1
                // }],
                aLengthMenu: [[-1, 10, 50, 100], ["Wszystkie", 10, 50, 100]],


            });


        },

    });

})(window, jQuery, $myFilters, $magazyny);