'use strict';

(function (window, $, myFilters) {
    window.DynamicsApp = function ($wrapper) {

        this.$wrapper = $wrapper;

        this._inits();

        this.$wrapper.on(
            'click',
            '.new',
            this.alertIt.bind(this)
        );

        this.$wrapper.find('#test').on(
            'click',
            '.test',
            this.alertIt.bind(this)
        );

        this.$wrapper.on(
            'change',
            '.chInput',
            this.sumInputs.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#closeFilters',
            this.toggleFilters.bind(this)
        );

        this.$wrapper.on(
            'click',
            '#openFilters',
            this.toggleFilters.bind(this)
        );

    };

    $.extend(window.DynamicsApp.prototype, {

        alertIt: function (e) {
            e.preventDefault();
            alert("it's working");
        },

        toggleFilters: function (e) {
            e.preventDefault();
            $('#closeFilters, #openFilters, #filters').toggle();
        },
        sumInputs: function (e) {
            e.preventDefault();
            var self = e.currentTarget;

            var sumBy = $(self).data('class');
            var magazyn = $(self).data('magazyn');

            var sum = 0;
            $( ".input-" + sumBy ).each(function() {
                if($.isNumeric($(this).val())){
                    sum = sum + parseInt($(this).val());
                }
            });
            $(".sum[data-id=" + sumBy + "]").html(sum);

            var dostepne = parseInt($(".dostepne[data-id=" + sumBy + "]").html());
            var zamowione = parseInt($(".sum[data-id=" + sumBy + "]").html());

            $(".pozostale[data-id=" + sumBy + "]").html(dostepne - zamowione);

            var sumZamowiono = parseInt($(".sumZamowiono[data-id=" + magazyn + "]").html());

            $(".sumZamowiono[data-id=" + magazyn + "]").html(sumZamowiono + zamowione);

        },

        _inits: function (e) {
            $('.dropdown').dropdown({
                "fullTextSearch": "exact"
            });

            $('.ui.radio.checkbox')
                .checkbox()
            ;


            $('.chosen').chosen();


            $("#dateFrom").flatpickr({locale: "pl", defaultDate: myFilters.dateFrom});
            $("#dateTo").flatpickr({locale: "pl", defaultDate: myFilters.dateTo});

            jQuery.extend( jQuery.fn.dataTableExt.oSort, {
                "polish-string-asc" : function (s1, s2) {
                    return s1.localeCompare(s2);
                },

                "polish-string-desc" : function (s1, s2) {
                    return s2.localeCompare(s1);
                }
            } );

            var wHeight = window.innerHeight;


            var table = $('#dataTable').DataTable({
                responsive: false,
                fixedColumns: {
                    leftColumns: 4
                },
                scrollX: true,
                scrollY: (wHeight - 300) + "px",
                bPaginate: false,
                bLengthChange: false,
                bFilter: false,
                bInfo: false,
                bAutoWidth: false,
                // columnDefs: [{
                //     type: 'polish-string',
                //     targets: 1
                // }],
                aLengthMenu: [[-1, 10, 50, 100], ["Wszystkie", 10, 50, 100]],


            });


        },

    });

})(window, jQuery, $myFilters);