<?php

include 'requires.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


class docsController
{

    const ZAM_NIEZREALIZOWANE = 5,
        ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI = 6,
        ZAM_NIEZREALIZOWANE_Z_REZERWACJA = 7;

    const STATUS_OK = 1,
        STATUS_ERROR = 2,
        STATUS_ERRORS = 3,
        STATUS_WYSTAW_MM = 4,
		STATUS_WARNING = 5;

    const TYP_WZ = 1,
        TYP_PZ = 2;

    const ZAMOWIENIE_OD_KLIENTOW = 16,
        ZAMOWIENIE_DO_DOSTAWCOW = 15;

    public function indexAction()
    {

        $db = new connectionController;
        $pdo = $db->getPdo();
        $tw = new twigController;
        $twig = $tw->getTwig();

        echo $twig->render('docs/index.html.twig', ['magazyny' => $this->getMagazines()]);

    }

    public function generateAction(){

        $tw = new twigController;
        $twig = $tw->getTwig();

        $params = $this->getParams();


        move_uploaded_file(str_replace(' ', '', $_FILES['plik']['tmp_name']), "csv/" . str_replace(' ', '', $_FILES['plik']['name']));

        $check = 1;

        if($params['typ'] == self::TYP_WZ){
            if($params['multi']){
                $this->multiWystawWZ();
            }else{
                $this->singleWystawWZ();
            }
        }elseif ($params['typ'] == self::TYP_PZ){
            if($params['multi']){
                $this->multiWystawPZ();
            }else{
                $this->singleWystawPZ();
            }
        }else{
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'error' => "Błędny typ dokumentu"]);
            return;
        }

    }

    private function getParams(){

        $params = [
            'magazyn' => $_POST['magazyn'],
            'zamowienie' => isset($_POST['zamowienie']) ?: null,
            'typ' => $_POST['typ'],
            'multi' => isset($_POST['multi']) ? true : false,
            'plik' => $_FILES['plik']['name']
        ];

        return $params;

    }

    private function singleWystawWZ(){

        $params = $this->getParams();

        $idZam = $_POST['zamowienie'];
        $magazynId = $_POST['magazyn'];

        $tw = new twigController;
        $twig = $tw->getTwig();

        $symbolsFromCsv = $this->buildArrayFromCsv($_FILES['plik']['name']);

        $buildArrayFromSubiekt = $this->buildArrayFromSubiekt($idZam);
        $pozycjeSubiekt =  $buildArrayFromSubiekt['pozycje'];


        if($buildArrayFromSubiekt['noweIdZam'] > 0){
            $idZam = $buildArrayFromSubiekt['noweIdZam'];
        }

        foreach($pozycjeSubiekt as $key => $pozycja){
            if(array_key_exists($key, $symbolsFromCsv)){
                $positionsToNewDoc[$key]['ilosc'] = $symbolsFromCsv[$key];
                $positionsToNewDoc[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                $positionsToNewDoc[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
                if($symbolsFromCsv[$key] < $pozycja['ilosc']){
                    $positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'] - $symbolsFromCsv[$key];
                    $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                    $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
                }
            }else{
                $positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'];
                $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
            }
        }

        $wystawWz = $this->wystawWz($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder);

        if($wystawWz['status'] == self::STATUS_ERROR){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'error' => $wystawWz['error']]);
            return;
        }
        if($wystawWz['status'] == self::STATUS_ERRORS){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'errors' => $wystawWz['errors']]);
            return;
        }
        if($wystawWz['status'] == self::STATUS_OK){

            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'success' => "Wystawiono dokument"]);
            return;
        }

    }

    private function multiWystawWZ(){

        $params = $this->getParams();

        $idZam = $_POST['zamowienie'];
        $magazynId = $_POST['magazyn'];

        $tw = new twigController;
        $twig = $tw->getTwig();

        $symbolsFromCsv = $this->buildMultiArrayFromCsv($_FILES['plik']['name']);
	    $symbolsFromCsv1 = $this->buildMultiArrayFromCsv1($_FILES['plik']['name']);

		$nr_listu= $symbolsFromCsv1[0];
		//	die(var_dump($nr_listu));
		$warnings = [];
	
        foreach ($symbolsFromCsv as $nrZam => $order) {

            $idZam = $this->ZmienNumerNaId($nrZam);
			$nr_listu= $order['nr'];
			
            $buildArrayFromSubiekt =  $this->buildArrayFromSubiekt($idZam);
            $pozycjeSubiekt =  $buildArrayFromSubiekt['pozycje'];

            if($buildArrayFromSubiekt['noweIdZam'] > 0){
                $idZam = $buildArrayFromSubiekt['noweIdZam'];
            }

            $positionsToNewDoc = [];
            $positionsToNewOrder = [];
			
			foreach($pozycjeSubiekt as $key => $pozycja){
				if(array_key_exists($key, $order['towary'])){
					$positionsToNewDoc[$key]['ilosc'] = $order['towary'][$key];
                    $positionsToNewDoc[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                    $positionsToNewDoc[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
					if($order['towary'][$key] < $pozycja['ilosc']){
                        $positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'] - $order['towary'][$key];
                        $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                        $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
                    }
				}else{
					$positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'];
                    $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                    $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
				}
			}
	
     //       echo "<pre>"; 
	//	die(var_dump($nr_listu));
            $wystawWz = $this->wystawWz($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder, $nr_listu);
			
			if($wystawWz['status'] == self::STATUS_WARNING){
				$warnings[] = $wystawWz['warning'];
			}

            //jezeli kontrahent jest w zzzRobmar_magazyny_kontrahentow wystawiamy MM zamiast WZ
             if($wystawWz['status'] == self::STATUS_WYSTAW_MM) {
				
                 $wystawWz = $this->wystawMM($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder, $nr_listu);
				 
             }

        }

        if($wystawWz['status'] == self::STATUS_ERROR){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'error' => $wystawWz['error']]);
            return;
        }
        if($wystawWz['status'] == self::STATUS_ERRORS){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'errors' => $wystawWz['errors']]);
            return;
        }
        if($wystawWz['status'] == self::STATUS_OK || $wystawWz['status'] == self::STATUS_WARNING){

            echo $twig->render('docs/index.html.twig', ['params' => $params, 'warnings' => $warnings,'magazyny' => $this->getMagazines(), 'success' => "Skrypt nie napotkał błędów"]);
            return;
        }

    }

    private function singleWystawPZ(){

        $params = $this->getParams();

        $idZam = $_POST['zamowienie'];
        $magazynId = $_POST['magazyn'];

        $tw = new twigController;
        $twig = $tw->getTwig();

        $symbolsFromCsv = $this->buildArrayFromCsv($_FILES['plik']['name']);

        $pozycjeSubiekt = $this->buildArrayPzFromSubiekt($idZam);

        foreach($pozycjeSubiekt as $key => $pozycja){
            if(array_key_exists($key, $symbolsFromCsv)){
                $positionsToNewDoc[$key]['ilosc'] = $symbolsFromCsv[$key];
                $positionsToNewDoc[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                $positionsToNewDoc[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
                if($symbolsFromCsv[$key] < $pozycja['ilosc']){
                    $positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'] - $symbolsFromCsv[$key];
                    $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                    $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
                }
            }else{
                $positionsToNewOrder[$key]['ilosc'] = $pozycja['ilosc'];
                $positionsToNewOrder[$key]['CenaNettoPrzedRabatem'] = $pozycja['CenaNettoPrzedRabatem'];
                $positionsToNewOrder[$key]['CenaNettoPoRabacie'] = $pozycja['CenaNettoPoRabacie'];
            }
        }



        $wystawPz = $this->wystawPz($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder);

        if($wystawPz['status'] == self::STATUS_ERROR){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'error' => $wystawPz['error']]);
            return;
        }
        if($wystawPz['status'] == self::STATUS_ERRORS){
            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'errors' => $wystawPz['errors']]);
            return;
        }
        if($wystawPz['status'] == self::STATUS_OK){

            echo $twig->render('docs/index.html.twig', ['params' => $params, 'magazyny' => $this->getMagazines(), 'success' => "Wystawiono dokument"]);
            return;
        }


    }

    private function getMagazines(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $magazyny = $pdo->query("SELECT m.* FROM dbo.sl_Magazyn m ORDER BY m.mag_Nazwa");
        $magazyny = $magazyny->fetchAll();

        return $magazyny;

    }

    private function wystawWz($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder, $nr_listu){

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();
		

        $Subiekt->MagazynId = intval($magazynId);

        $zamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        $kontrahentId = $zamowienie->KontrahentId;

        $kontrahenciDlaMM = $this->KontrahenciDlaMM();

        if(in_array($kontrahentId, $kontrahenciDlaMM)){
            return ['status' => self::STATUS_WYSTAW_MM];
        }
		
		$podtyp = $zamowienie->Podtyp;
		
		if($podtyp != 1){
						$fs = $Subiekt->SuDokumentyManager->DodajFS();
					
					
					//die(var_dump($positionsToNewDoc));
					
					try{
						$fs->NaPodstawie($zamowienie);
					}catch(Exception $e){
						return ['status' => self::STATUS_WARNING, 'warning' => "Nie da się wystawić FS na podstawie zamówienia: ".$zamowienie->NumerPelny];
					}
					
				   
					//usuwa stare pozycje, poniewaz chcemy dodac swoje z nowymi ilosciami
					$ilePozycji = $fs->Pozycje->Liczba;
					
					for($i = $ilePozycji; $i > 0; $i--){
						$fs->Pozycje[$i]->Usun();
					}
					

					//try{
					//	$fs->KontrahentId = intval($kontrahentId);
					//}
					//catch (Exception $e){
					//	return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
					//}

					$errors = [];

					//$kurs = $this->PobierzKursCenyZamowienia($zamowienie->Identyfikator);
					
							
					foreach ($positionsToNewDoc as $key => $position) {
						try{
							$towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
						}catch(Exception $e){
							return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
						}
						$stan = $this->SprawdzStanMagazynowy($towar->Identyfikator, $magazynId);

						if(intval($stan['st_Stan'] < $position['ilosc'])){
							$errors[] = "Za mała ilość towaru na magazynie: " . $key ." (" . intval($stan['st_Stan']) . " - ". $position['ilosc'].")";
						}else{
							$oPoz = $fs->Pozycje->Dodaj(intval($towar->Identyfikator));
							$oPoz->IloscJm = floatval($position['ilosc']);
							$oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
							$oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
						}

					}

					if(count($errors) > 0){
						return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
					}

					try{
						$fs->StatusDokumentu = 0;

						$fs->Uwagi = $zamowienie->Uwagi." ".$zamowienie->NumerPelny;
						
									$db1 = new connectionController;
									$pdo1 = $db1->getPdo();
									//odczyt pierwotnego terminu oraz sposoby platnosci
									$termin = $pdo1->query("SELECT DATEDIFF(day,dok_DataWyst,dok_PlatTermin) AS termin_patnosci,dok_KatId FROM dok__Dokument Where dok_id ='".$idZam."' ");
									$termin = $termin->fetch();
									$ilosc_dni_patnosci = $termin['termin_patnosci'];
									$dok_KatId = intval($termin['dok_KatId']);
									//
									//$wzwlasny = $pdo->query("SELECT [pwd_Fk01] FROM [pw_Dane] where pwd_TypObiektu=-12 AND pwd_IdObiektu='".$idZam."' ");
									//$wzwlasny = $wzwlasny->fetch();
									//$wz_wlasny = $wzwlasny['pwd_Fk01'];
									//
									//$wzwlasny = $pdo->query("SELECT [pwd_Fk01] FROM [pw_Dane] where pwd_TypObiektu=-12 AND pwd_IdObiektu='".$kontrahentId."' ");
									//$wzwlasny = $wzwlasny->fetch();
									//$wz_wlasny = $wzwlasny['pwd_Fk01'];
									
						$date = new DateTime('+'.$ilosc_dni_patnosci.' day');
						$date = $date->format('Y-m-d');
								//die(var_dump($date));
						$fs -> PlatnoscKredytTermin = $date ;
						//die(var_dump($dok_KatId));
						if ($dok_KatId = "30") 
									{
										$str_uwagi = $zamowienie->Uwagi." \r\n Płatność w terminie: ".$ilosc_dni_patnosci." dni = ".$date." ";
										$str_uwagi = iconv( "UTF-8","Windows-1250", $str_uwagi);
										$fs->Uwagi = $str_uwagi;
									}

						$fs->Zapisz();
						
						
						
						$tId = $fs->Identyfikator;
						$tnumerPelny = $fs->NumerPelny;
						$tnumerPelny = str_replace("/", "_", $tnumerPelny);
						$tnumerPelny = str_replace(" ", "_", $tnumerPelny);
						$Subiekt->UstawPoleWlasne($fs , "NR_LISTU_PRZEWOZOWEGO" , $nr_listu );
						$fs->Zamknij();
						
						$fsWywolajSkutek = $Subiekt->SuDokumentyManager->WczytajDokument(intval($tId));
						$fsWywolajSkutek->StatusDokumentu = 1;
						$oBraki = $fsWywolajSkutek->PozycjeBrakujace; 
						$oBraki->PomijanieRezerwacji = true;
						
						
						$fsWywolajSkutek->Zapisz();
						
						$fsWywolajSkutek->Zamknij();
						
						$zamowienie->Zamknij();
						
						           
						$zamknijZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));
						
						$zamknijZamowienie->Rezerwacja = false;
						$zamknijZamowienie->StatusDokumentu = 8;
						$zamknijZamowienie->Zapisz();
						$zamknijZamowienie->Zamknij();
						
						$dodruku = $Subiekt->SuDokumentyManager->WczytajDokument($tId);
		
						
					}catch (Exception $e){
						return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
					}
			        $temp = "C:/xampp/htdocs/docs/pdf/".$tnumerPelny.".pdf";
					
			//pobieramy ID wzorca wydruku zapisany jest w polu wlasnym kontrahenta 		
					
			$db = new connectionController;
			$pdo = $db->getPdo();
			$wzwlasny = $pdo->query("SELECT [pwd_Fk01] FROM [pw_Dane] where pwd_TypObiektu=-12 AND pwd_IdObiektu='".$kontrahentId."' ");
			$wzwlasny = $wzwlasny->fetch();
			$wz_wlasny = $wzwlasny['pwd_Fk01'];
			if (empty($wz_wlasny)){
				$dodruku->DrukujDoPliku($temp, 0);
			}
			else
			{
				$dodruku->DrukujDoPlikuWgWzorca($wz_wlasny, $temp, 0);
			}
						$dodruku->Zamknij();
						
						        $mail = new PHPMailer;

        $mail->IsSMTP(); // telling the class to use SMTP
        $mail->Host       = "smtp-pitbull.ogicom.pl"; // SMTP server
        //$mail->SMTPDebug  = 1;                     // enables SMTP debug information (for testing)
        // 1 = errors and messages
        // 2 = messages only
        $mail->SMTPSecure = 'ssl';                 // enable SMTP authentication
        $mail->SMTPAuth   = true;                  // enable SMTP authentication
        $mail->Host       = "smtp-pitbull.ogicom.pl"; // sets the SMTP server
        $mail->Port       = 465;                    // set the SMTP port for the GMAIL server
        $mail->Username   = "serwis2@pitbull.pl"; // SMTP account username
        $mail->Password   = "NpcqRE8x";        // SMTP account password

        $mail->SetFrom('serwis2@pitbull.pl', 'PBWC mailing info');
        $mail->CharSet = 'UTF-8';
		$mail->Subject  = "$tnumerPelny";
		$body = "<p>Została nadana przesyłka z Magazynu z numerem listu przewozowego ".$nr_listu."</p>";
		$body .= "<br>Dla dokumentu ".$tnumerPelny."</br>";
		$body .= "<br>numer listu przewozowego: <a href=".Chr(34)."https://gls-group.eu/PL/pl/sledzenie-paczek?match=".$nr_listu.Chr(34).">".$nr_listu."</a> </br>";
		$body .= "<br>Pozdrawiamy, wasz automat ;)</br>";
		$mail->MsgHTML($body);
		$mail->AddAddress("marcin@robmar.eu", "Marcin");
		$mail->addAttachment($temp);
		$mail->AddAddress("marcin@robmar.eu", "Marcin");
		$mail->AddAddress("paulina@pitbull.pl", "Paulina Łaskarzewska");
                    if(!$mail->Send()) {
                        echo "Mailer Error: " . $mail->ErrorInfo;
                    } else {
                        echo "Message sent!";
                    }
		
		}
			else{
						$wz = $Subiekt->SuDokumentyManager->DodajWZv();
						
						
						//die(var_dump($positionsToNewDoc));
						
						try{
							$wz->NaPodstawie($zamowienie);
						}catch(Exception $e){
							return ['status' => self::STATUS_WARNING, 'warning' => "Nie da się wystawić WZ na podstawie zamówienia: ".$zamowienie->NumerPelny];
						}
						
					   
						//usuwa stare pozycje, poniewaz chcemy dodac swoje z nowymi ilosciami
						$ilePozycji = $wz->Pozycje->Liczba;
						
						for($i = $ilePozycji; $i > 0; $i--){
							$wz->Pozycje[$i]->Usun();
						}
						

						try{
							$wz->KontrahentId = intval($kontrahentId);
						}
						catch (Exception $e){
							return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
						}

						$errors = [];

						$kurs = $this->PobierzKursCenyZamowienia($zamowienie->Identyfikator);
						
								
						foreach ($positionsToNewDoc as $key => $position) {
							try{
								$towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
							}catch(Exception $e){
								return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
							}
							$stan = $this->SprawdzStanMagazynowy($towar->Identyfikator, $magazynId);

							if(intval($stan['st_Stan'] < $position['ilosc'])){
								$errors[] = "Za mała ilość towaru na magazynie: " . $key ." (" . intval($stan['st_Stan']) . " - ". $position['ilosc'].")";
							}else{
								$oPoz = $wz->Pozycje->Dodaj(intval($towar->Identyfikator));
								$oPoz->IloscJm = floatval($position['ilosc']);
								$oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
								$oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
							}

						}

						if(count($errors) > 0){
							return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
						}

						try{
							$wz->StatusDokumentu = 0;

							$wz->Uwagi = $zamowienie->Uwagi." ".$zamowienie->NumerPelny;

							$wz->Zapisz();
							
							
							
							$tId = $wz->Identyfikator;
							$Subiekt->UstawPoleWlasne($wz , "NR_LISTU_PRZEWOZOWEGO" , $nr_listu );
							$wz->Zamknij();
							
							$wzWywolajSkutek = $Subiekt->SuDokumentyManager->WczytajDokument(intval($tId));
							$wzWywolajSkutek->StatusDokumentu = 1;
							$oBraki = $wzWywolajSkutek->PozycjeBrakujace; 
							$oBraki->PomijanieRezerwacji = true;
							
							
							$wzWywolajSkutek->Zapisz();
							
							$wzWywolajSkutek->Zamknij();
							
							$podtyp = $zamowienie->Podtyp;
						  
							$zamowienie->Zamknij();

							if($podtyp != 1){
								$zamknijZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));
								
								$zamknijZamowienie->Rezerwacja = false;
								$zamknijZamowienie->StatusDokumentu = 8;
								$zamknijZamowienie->Zapisz();
								$zamknijZamowienie->Zamknij();
							}

							//$dodruku = $Subiekt->SuDokumentyManager->WczytajDokument(179950);

						}catch (Exception $e){
							return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
						}
			}
//        $temp = "C:\\xampp2\htdocs\pitbull\docs\pdf\aTest.pdf";
//        //die(var_dump($temp));
//        //$dodruku->DrukujDoPlikuWgWzorca(448, $temp, 0);
//        $dodruku->DrukujDoPliku($temp, 0);


        $Subiekt->Zakoncz();
         		 
		
        if($podtyp != 1 && count($positionsToNewOrder) > 0) {
	
            $wystawZk = $this->wystawZK($idZam, $magazynId, $positionsToNewOrder);

            if($wystawZk['status'] == self::STATUS_OK) {
                return ['status' => self::STATUS_OK];
            }else{
                return ['status' => self::STATUS_ERROR, 'error' => "Nie wygenerowano zamówienia różnicowego"];
            }
        }

        return ['status' => self::STATUS_OK];

    }

    private function wystawPz($idZam, $magazynId, $positionsToNewDoc, $positionsToNewOrder){

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $Subiekt->MagazynId = intval($magazynId);

        $zamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        $kontrahentId = $zamowienie->KontrahentId;

        $pz = $Subiekt->SuDokumentyManager->DodajPZ();

        try{
            $pz->NaPodstawie($zamowienie);
        }catch(Exception $e){
            return ['status' => self::STATUS_WARNING, 'warning' => "Nie da się wystawić PZ na podstawie zamówienia: ".$zamowienie->NumerPelny];
        }


        //usuwa stare pozycje, poniewaz chcemy dodac swoje z nowymi ilosciami
        $ilePozycji = $pz->Pozycje->Liczba;

        for($i = $ilePozycji; $i > 0; $i--){
            $pz->Pozycje[$i]->Usun();
        }

        try{
            $pz->KontrahentId = intval($kontrahentId);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
        }

        $errors = [];

        $kurs = $this->PobierzKursCenyZamowienia($zamowienie->Identyfikator);
        

        foreach ($positionsToNewDoc as $key => $position) {
            try{
                $towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
            }catch(Exception $e){
                return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
            }

            $oPoz = $pz->Pozycje->Dodaj(intval($towar->Identyfikator));
            $oPoz->IloscJm = floatval($position['ilosc']);
            $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']*$kurs);
            $oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']*$kurs);

        }

        if(count($errors) > 0){
            return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
        }


        try{

            $pz->Uwagi = $zamowienie->Uwagi." ".$zamowienie->NumerPelny;

            $pz->Zapisz();
            $pz->Zamknij();

            $podtyp = $zamowienie->Podtyp;

            $zamowienie->Zamknij();


            $zamknijZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

            //$zamknijZamowienie->Rezerwacja = false;
            $zamknijZamowienie->StatusDokumentu = 8;
            $zamknijZamowienie->Zapisz();
            $zamknijZamowienie->Zamknij();


        }catch (Exception $e) {
            return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
        }


        $Subiekt->Zakoncz();



        if(count($positionsToNewOrder) > 0) {

            $wystawZd = $this->wystawZD($idZam, $magazynId, $positionsToNewOrder);

            if($wystawZd['status'] == self::STATUS_OK) {
                return ['status' => self::STATUS_OK];
            }else{
                return ['status' => self::STATUS_ERROR, 'error' => "Nie wygenerowano zamówienia różnicowego"];
            }
        }

        return ['status' => self::STATUS_OK];

    }

    private function wystawZK($idZam, $magazynId, $positionsToNewOrder){

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $Subiekt->MagazynId = intval($magazynId);

        $zk = $Subiekt->SuDokumentyManager->DodajZK();
        $zk->Rezerwacja = true;
		
        $zamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        $staryId = $zamowienie->Identyfikator;
        $staryNumer = $zamowienie->NumerPelny;

        $kontrahentId = $zamowienie->KontrahentId;
		$zk->Uwagi = $zamowienie->Uwagi;
		$zk->LiczonyOdCenBrutto = $zamowienie->LiczonyOdCenBrutto;
		$zk->LiczonyOdCenNetto = $zamowienie->LiczonyOdCenNetto;
		$zk->PoziomCenyId = $zamowienie->PoziomCenyId;
		$zk->TransakcjaRodzajOperacjiVat = $zamowienie->TransakcjaRodzajOperacjiVat;					

		if($zamowienie->WalutaSymbol != "PLN"){
			if($zamowienie->KursCenyDataKursu != NULL){$zk->KursCenyDataKursu = $zamowienie->KursCenyDataKursu;}
			if($zamowienie->KursCenyTabelaBanku != NULL){$zk->KursCenyTabelaBanku = $zamowienie->KursCenyTabelaBanku;}
			$zk->KursCenyTypKursu = $zamowienie->KursCenyTypKursu;
			if($zamowienie->WalutaDataKursu != NULL){$zk->WalutaDataKursu = $zamowienie->WalutaDataKursu;}
			$zk->WalutaLiczbaJednostek = $zamowienie->WalutaLiczbaJednostek;
			$zk->WalutaSymbol = $zamowienie->WalutaSymbol;
			if($zamowienie->WalutaTabelaBanku != NULL){$zk->WalutaTabelaBanku = $zamowienie->WalutaTabelaBanku;}
			$zk->WalutaTypKursu = $zamowienie->WalutaTypKursu;
			$zk->KursCeny = $zamowienie->KursCeny;
			$zk->WalutaKurs = $zamowienie->WalutaKurs;
		}
//catch(Exception $e){
//die(var_dump($e->getMessage()));
//}
		

        try{
            $zk->KontrahentId = intval($kontrahentId);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
        }

        foreach ($positionsToNewOrder as $key => $position) {
            try{
                $towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
            }catch(Exception $e){
                return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
            }

            $oPoz = $zk->Pozycje->Dodaj(intval($towar->Identyfikator));
            $oPoz->IloscJm = floatval($position['ilosc']);
            $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
            $oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
        }


        try{

            $zk->Zapisz();

            $noweId = $zk->Identyfikator;
			
			$db = new connectionController;
			$pdo = $db->getPdo();
			$zkwlasny = $pdo->query("SELECT pwd_Fk01,pwd_Fk02 FROM pw_Dane where pwd_TypObiektu=-8 and pwd_IdObiektu = '".$idZam."' ");
			$zkwlasny = $zkwlasny->fetch();
			$zk_wlasny = $zkwlasny['pwd_Fk01'];
			$zk_wlasny2 = $zkwlasny['pwd_Fk02'];
			$Subiekt->UstawPoleWlasne($zk , "KURIER" , $zk_wlasny );
			$Subiekt->UstawPoleWlasne($zk , "Termin_platnosci_faktoring" , $zk_wlasny2 );
            $zk->Zamknij();

        }catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
        }
		
        $Subiekt->Zakoncz();

        $this->PowiazDokumenty($noweId, $staryId, $staryNumer);

        return ['status' => self::STATUS_OK];

    }

    private function wystawZD($idZam, $magazynId, $positionsToNewOrder){

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $Subiekt->MagazynId = intval($magazynId);

        $zd = $Subiekt->SuDokumentyManager->DodajZD();
        //$zd->Rezerwacja = true;

        $zamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        $staryId = $zamowienie->Identyfikator;
        $staryNumer = $zamowienie->NumerPelny;

        $kontrahentId = $zamowienie->KontrahentId;
        $zd->Uwagi = $zamowienie->Uwagi;
        $zd->LiczonyOdCenBrutto = $zamowienie->LiczonyOdCenBrutto;
        $zd->LiczonyOdCenNetto = $zamowienie->LiczonyOdCenNetto;
        $zd->PoziomCenyId = $zamowienie->PoziomCenyId;
        $zd->TransakcjaRodzajOperacjiVat = $zamowienie->TransakcjaRodzajOperacjiVat;

        if($zamowienie->WalutaSymbol != "PLN"){
            if($zamowienie->KursCenyDataKursu != NULL){$zd->KursCenyDataKursu = $zamowienie->KursCenyDataKursu;}
            if($zamowienie->KursCenyTabelaBanku != NULL){$zd->KursCenyTabelaBanku = $zamowienie->KursCenyTabelaBanku;}
            $zd->KursCenyTypKursu = $zamowienie->KursCenyTypKursu;
            if($zamowienie->WalutaDataKursu != NULL){$zd->WalutaDataKursu = $zamowienie->WalutaDataKursu;}
            $zd->WalutaLiczbaJednostek = $zamowienie->WalutaLiczbaJednostek;
            $zd->WalutaSymbol = $zamowienie->WalutaSymbol;
            if($zamowienie->WalutaTabelaBanku != NULL){$zd->WalutaTabelaBanku = $zamowienie->WalutaTabelaBanku;}
            $zd->WalutaTypKursu = $zamowienie->WalutaTypKursu;
            $zd->KursCeny = $zamowienie->KursCeny;
            $zd->WalutaKurs = $zamowienie->WalutaKurs;
        }



        try{
            $zd->KontrahentId = intval($kontrahentId);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny kontrahent"];
        }

        foreach ($positionsToNewOrder as $key => $position) {
            try{
                $towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
            }catch(Exception $e){
                return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
            }

            $oPoz = $zd->Pozycje->Dodaj(intval($towar->Identyfikator));
            $oPoz->IloscJm = floatval($position['ilosc']);
            $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
            $oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
        }


        try{

            $zd->Zapisz();

            $noweId = $zd->Identyfikator;

            $zd->Zamknij();

        }catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
        }

        $Subiekt->Zakoncz();

        $this->PowiazDokumenty($noweId, $staryId, $staryNumer);

        return ['status' => self::STATUS_OK];

    }

    private function wystawMM($idZam, $magazynFromId, $positionsToNewDoc, $positionsToNewOrder, $nr_listu){

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $zamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        $kontrahentId = $zamowienie->KontrahentId;

        $mm = $Subiekt->SuDokumentyManager->DodajMM();


        try{
            $mm->MagazynNadawczyId = intval($magazynFromId);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn nadawczy"];
        }

        try{
            $magazynToId = $this->PobierzBuforDlaKontrahenta($kontrahentId);
            $mm->MagazynOdbiorczyId = intval($magazynToId);
        }
        catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => "Błędny magazyn odbiorczy"];
        }

        $errors = [];
        foreach ($positionsToNewDoc as $key => $position) {
            try{
                $towar = $Subiekt->TowaryManager->WczytajTowarWg($key, 2);
            }catch(Exception $e){
                return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
            }
            $stan = $this->SprawdzStanMagazynowy($towar->Identyfikator, $magazynFromId);

            if(intval($stan['st_Stan'] < $position['ilosc'])){
                $errors[] = "Za mała ilość towaru na magazynie: " . $key ." (" . intval($stan['st_Stan']) . " - ". $position['ilosc'].")";
            }else{
                $oPoz = $mm->Pozycje->Dodaj(intval($towar->Identyfikator));
                $oPoz->IloscJm = floatval($position['ilosc']);
                $oPoz->CenaNettoPrzedRabatem = floatval($position['CenaNettoPrzedRabatem']);
				$oPoz->CenaNettoPoRabacie = floatval($position['CenaNettoPoRabacie']);
            }

        }

        if(count($errors) > 0){
            return ['status' => self::STATUS_ERRORS, 'errors' => $errors];
        }

        try{
            $mm->StatusDokumentu = 0;

            $mm->Uwagi = $zamowienie->Uwagi." ".$zamowienie->NumerPelny;

			
            $mm->Zapisz();
			
			$tId = $mm->Identyfikator;
			$tnumerPelny = $mm->NumerPelny;

		//Odczyt maila sklepu przypisanego do danego magazynu w słowniku magazynów
			$db = new connectionController;
			$pdo = $db->getPdo();
			$am_email = $pdo->query("SELECT dok_Id, dok_NrPelny, dok_MagId, dok_Uwagi,adr__Ewid.adr_Id, adr_Email.am_Email FROM dok__Dokument Left JOIN adr__Ewid ON adr__Ewid.adr_IdObiektu = dok__Dokument.dok_OdbiorcaId Left JOIN adr_Email on adr__Ewid.adr_Id = adr_Email.am_IdAdres where adr__Ewid.adr_TypAdresu = 7 AND dok_NrPelny = '".$tnumerPelny."' ");
			$am_email = $am_email->fetch();
			$mm_email = $am_email['am_Email'];
			//zmiana nazwy aby usunac znaki specjalne i zastaic je "_"
			$tnumerPelny = str_replace("/", "_", $tnumerPelny);
			$tnumerPelny = str_replace(" ", "_", $tnumerPelny);
			
            $mm->Zamknij();
			
			$mmWywolajSkutek = $Subiekt->SuDokumentyManager->WczytajDokument(intval($tId));
			$mmWywolajSkutek->StatusDokumentu = 1;
			$oBraki = $mmWywolajSkutek->PozycjeBrakujace; 
			$oBraki->PomijanieRezerwacji = true;
			
			
			$mmWywolajSkutek->Zapisz();
			$mmWywolajSkutek->Zamknij();

            $zamowienie->Zapisz();
            $zamowienie->Zamknij();

            $zamknijZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));
            $zamknijZamowienie->Rezerwacja = false;
            $zamknijZamowienie->StatusDokumentu = 8;
            $zamknijZamowienie->Zapisz();
            $zamknijZamowienie->Zamknij();
			
			$dodruku = $Subiekt->SuDokumentyManager->WczytajDokument($tId);

        }catch (Exception $e){
            return ['status' => self::STATUS_ERROR, 'error' => $e->getMessage()];
        }
		$temp = "C:/xampp/htdocs/docs/pdf/".$tnumerPelny.".pdf";
//        $temp = "C:\\xampp2\htdocs\pitbull\docs\pdf\aTest.pdf";
//        //die(var_dump($temp));
//        //$dodruku->DrukujDoPlikuWgWzorca(448, $temp, 0);
        $dodruku->DrukujDoPliku($temp, 0);
		$dodruku->Zamknij();
		
		
        $Subiekt->Zakoncz();
		
        $mail = new PHPMailer;

        $mail->IsSMTP(); // telling the class to use SMTP
        $mail->Host       = "smtp-pitbull.ogicom.pl"; // SMTP server
        //$mail->SMTPDebug  = 1;                     // enables SMTP debug information (for testing)
        // 1 = errors and messages
        // 2 = messages only
        $mail->SMTPSecure = 'ssl';                 // enable SMTP authentication
        $mail->SMTPAuth   = true;                  // enable SMTP authentication
        $mail->Host       = "smtp-pitbull.ogicom.pl"; // sets the SMTP server
        $mail->Port       = 465;                    // set the SMTP port for the GMAIL server
        $mail->Username   = "serwis2@pitbull.pl"; // SMTP account username
        $mail->Password   = "NpcqRE8x";        // SMTP account password

        $mail->SetFrom('serwis2@pitbull.pl', 'PBWC mailing info');
        $mail->CharSet = 'UTF-8';
		$mail->Subject  = "$tnumerPelny";
		$body = "<p>Została nadana przesyłka z Magazynu z numerem listu przewozowego ".$nr_listu."</p>";
		$body .= "<p>Dla dokumentu ".$tnumerPelny."</p>";
		$body .= "<br>numer listu przewozowego: <a href=".Chr(34)."https://gls-group.eu/PL/pl/sledzenie-paczek?match=".$nr_listu.Chr(34).">".$nr_listu."</a> </br>";
		$body .= "<p>Pozdrawiamy, wasz automat ;)</p>";
		$mail->MsgHTML($body);
		$mail->addAttachment($temp);
		$mail->AddAddress("marcin@robmar.eu", "Marcin Kaminski");
		$mail->AddAddress("malgorzata@pitbull.pl", "Małgorzata Grec-Gulczyńska");
		$mail->AddAddress($mm_email);
                    if(!$mail->Send()) {
                        echo "Mailer Error: " . $mail->ErrorInfo;
                    } else {
                        echo "Message sent!";
                    }
		
		
        if(count($positionsToNewOrder) > 0) {
            $wystawZk = $this->wystawZK($idZam, $magazynFromId, $positionsToNewOrder);

            if($wystawZk['status'] == self::STATUS_OK) {
                return ['status' => self::STATUS_OK];
            }else{
                return ['status' => self::STATUS_ERROR, 'error' => "Nie wygenerowano zamówienia różnicowego"];
            }
        }

        return ['status' => self::STATUS_OK];



    }


    private function buildArrayFromCsv($csv){

        $symbolsFromCsv = [];

        $row = 1;
        if (($handle = fopen('csv/' . $csv, "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {


                if ($row != 1) {

                    if(!array_key_exists($data[0], $symbolsFromCsv)){
                        $symbolsFromCsv[$data[0]] = 1;
                    }else{
                        $symbolsFromCsv[$data[0]]++;
                    }

                }
                $row++;
            }
            fclose($handle);
        }

        return $symbolsFromCsv;

    }

    private function buildMultiArrayFromCsv($csv){

	$symbolsFromCsv = [];

        $row = 1;
        if (($handle = fopen('csv/' . $csv, "r")) !== FALSE) {
            $tmpZamId = 0;
            while (($data = fgetcsv($handle, 100000, ";")) !== FALSE) {


                if ($row != 1) {

                    if($row == 2){
                        $symbolsFromCsv[$data[0]]['nr'] = '';
                        $symbolsFromCsv[$data[0]]['towary'] = [];
                    }
                    if($tmpZamId != $data[0]){
                        $symbolsFromCsv[$data[0]]['nr'] = '';
                        $symbolsFromCsv[$data[0]]['towary'] = [];
                    }

                    if(!array_key_exists($data[2], $symbolsFromCsv[$data[0]]['towary'])){

                        $symbolsFromCsv[$data[0]]['towary'][$data[2]] = $data[4];
                        $symbolsFromCsv[$data[0]]['nr'] = $data[5];

                    }else{
                        $symbolsFromCsv[$data[0]]['towary'][$data[2]] += $data[4];
                    }

                    $tmpZamId = $data[0];

                }
                $row++;
            }
            fclose($handle);
        }
//echo "<pre>"; 
//die(var_dump($symbolsFromCsv));
        return $symbolsFromCsv;

    }
	
	private function buildMultiArrayFromCsv1($csv){

	$symbolsFromCsv = [];

        $row = 1;
        if (($handle = fopen('csv/' . $csv, "r")) !== FALSE) {
            $tmpZamId = 0;
            while (($data = fgetcsv($handle, 100000, ";")) !== FALSE) {


                if ($row != 1) {

                    if($row == 2){
                        $symbolsFromCsv = [$data[5]];
                    }
                    

                    
                }
                $row++;
            }
            fclose($handle);
        }

        return $symbolsFromCsv;

    }

    private function buildArrayFromSubiekt($idZam){

        $pozycjeSubiekt = [];

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();

        $zamowienieRoznicoweId = 0;

        $sZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));

        if($this->SprawdzCzyZamowienieZrealizowane($idZam)){

            $zamowienieRoznicoweId = $this->PodmienZamowienieNaRoznicowe(intval($idZam));

			if($zamowienieRoznicoweId){
					try{
					$sZamowienie->Zamknij();
					$sZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($zamowienieRoznicoweId));
				}
				catch (Exception $e){

					$Subiekt->Zakoncz();
					die(var_dump("Zamowienie: ".$idZam." jest zamkniete i nie znaleziono zamowienia roznicowego!"));
				}
			}

        }

        foreach($sZamowienie->Pozycje as $pozycja){
            $pozycjeSubiekt[$pozycja->TowarSymbol]['ilosc'] = floatval($pozycja->Ilosc);
            $pozycjeSubiekt[$pozycja->TowarSymbol]['CenaNettoPrzedRabatem'] = floatval($pozycja->CenaNettoPrzedRabatem);
			$pozycjeSubiekt[$pozycja->TowarSymbol]['CenaNettoPoRabacie'] = floatval($pozycja->CenaNettoPoRabacie);

        }

        $Subiekt->Zakoncz();

        return ['pozycje' => $pozycjeSubiekt, 'noweIdZam' => $zamowienieRoznicoweId];

    }

    private function buildArrayPzFromSubiekt($idZam){

        $pozycjeSubiekt = [];

        $conn = new connectionController;
        $Subiekt = $conn->sferaConnect();


        $sZamowienie = $Subiekt->SuDokumentyManager->WczytajDokument(intval($idZam));


        foreach($sZamowienie->Pozycje as $pozycja){
            $pozycjeSubiekt[$pozycja->TowarSymbol]['ilosc'] = floatval($pozycja->Ilosc);
            $pozycjeSubiekt[$pozycja->TowarSymbol]['CenaNettoPrzedRabatem'] = floatval($pozycja->CenaNettoPrzedRabatem);
            $pozycjeSubiekt[$pozycja->TowarSymbol]['CenaNettoPoRabacie'] = floatval($pozycja->CenaNettoPoRabacie);

        }

        $Subiekt->Zakoncz();

        return $pozycjeSubiekt;

    }

    public function loadOrdersAction(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $docStatuses = [self::ZAM_NIEZREALIZOWANE, self::ZAM_NIEZREALIZOWANE_BEZ_REZERWACJI, self::ZAM_NIEZREALIZOWANE_Z_REZERWACJA];
        $magId = $_POST['id'];
        $typ = $_POST['typ'];

        if($typ == self::TYP_WZ){
            $docType = self::ZAMOWIENIE_OD_KLIENTOW;

            $orders = $pdo->query("SELECT d.dok_Id, d.dok_NrPelny, k.kh_Symbol FROM dbo.dok__Dokument d LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
WHERE d.dok_MagId = $magId AND d.dok_Typ = ".$docType." AND d.dok_Status IN(".implode(',', $docStatuses).")");
        }elseif ($typ == self::TYP_PZ){
            $docType = self::ZAMOWIENIE_DO_DOSTAWCOW;

            $orders = $pdo->query("SELECT d.dok_Id, d.dok_NrPelny, k.kh_Symbol FROM dbo.dok__Dokument d LEFT JOIN dbo.kh__Kontrahent k ON d.dok_PlatnikId=k.kh_Id 
WHERE d.dok_MagId = $magId AND d.dok_Typ = ".$docType." ");
        }


        $orders = $orders->fetchAll();

        $return['newOptions'] = '<option value="0">Wybierz zamówienie</option>';
        foreach($orders as $order){
            $return['newOptions'] .= '<option value="'.$order['dok_Id'].'">'.$order['dok_NrPelny'].' ('.$order['kh_Symbol'].')</option>';
        }


        echo json_encode($return);

    }

    private function SprawdzStanMagazynowy($idTowaru, $magazynId)
    {

        $db = new connectionController;
        $pdo = $db->getPdo();

        $stan = $pdo->query("SELECT * FROM dbo.tw_Stan WHERE st_MagId = ".$magazynId." AND st_TowId = " . $idTowaru . " ");
        $stan = $stan->fetch();

        return $stan;
    }

    private function ZmienNumerNaId($numer){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.dok__Dokument WHERE dok_NrPelny = '".$numer."' ");
        $id = $id->fetch();

        return $id['dok_Id'];
    }

    private function PodmienZamowienieNaRoznicowe($idZam){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.dok__Dokument WHERE dok_DoDokId = ".$idZam." AND dok_Typ = ".self::ZAMOWIENIE_OD_KLIENTOW." ");
        $id = $id->fetch();

        return $id['dok_Id'];
    }
	
	private function SprawdzCzyZamowienieZrealizowane($idZam){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.dok__Dokument WHERE dok_Id = ".$idZam." ");
        $id = $id->fetch();
		
		if($id["dok_Status"] == 8){
			return true;
		}
		if($id["dok_Status"] == 6 && $id["dok_StatusEx"] == 2){
			return true;
		}

        return false;
    }

    private function KontrahenciDlaMM(){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.zzzRobmar_magazyny_kontrahentow");
        $id = $id->fetchAll();

        $ids = [];
        foreach ($id as $i){
            $ids[] = $i['kontrahentId'];
        }

        return $ids;
    }

	private function PobierzKursCenyZamowienia($idZam){

		$db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.dok__Dokument WHERE dok_Id = ".$idZam." ");
        $id = $id->fetch();

        return $id['dok_CenyKurs'];

	}

    private function PobierzBuforDlaKontrahenta($kontrahentId){

        $db = new connectionController;
        $pdo = $db->getPdo();

        $id = $pdo->query("SELECT * FROM dbo.zzzRobmar_magazyny_kontrahentow WHERE kontrahentId=".$kontrahentId." ");
        $id = $id->fetch();

        return $id['buforId'];
    }

    private function PowiazDokumenty($nowy, $staryId, $staryNumer){

        $db = new connectionController;
        $pdo = $db->getPdo();


        $stmt = $pdo->prepare("UPDATE dbo.dok__Dokument SET dok_DoDokId=:sId, dok_DoDokNrPelny=:sNumer WHERE dok_Id = ".$nowy." AND dok_Typ = ".self::ZAMOWIENIE_OD_KLIENTOW." ");

        $stmt->bindValue(':sId', $staryId, PDO::PARAM_INT);
        $stmt->bindValue(':sNumer', $staryNumer, PDO::PARAM_STR);

        $stmt->execute();

    }

}


?>
