'use strict';

(function (window, $) {
    window.DocsApp = function ($wrapper) {

        this.$wrapper = $wrapper;

        this._inits();

        this.$wrapper.on(
            'change',
            '#selectMagazyn',
            this.loadOrders.bind(this, 0)
        );

        this.$wrapper.on(
            'change',
            '#selectTyp',
            this.loadOrders.bind(this, 0)
        );

        this.$wrapper.on(
            'click',
            '#submitForm',
            this.submitForm.bind(this, 0)
        );

    };

    $.extend(window.DocsApp.prototype, {

        loadOrders: function (e, zamowienie) {

            var selectMagazyn = $('#selectMagazyn').val();
            var selectTyp = $('#selectTyp').val();

            if(selectMagazyn > 0 && selectTyp > 0){
                $.ajax({ type: 'POST', url: 'docs.php?action=loadOrders', dataType: 'json', data: {
                    id: selectMagazyn,
                    typ: selectTyp

                }	, success: function(data) {

                    $('#selectOrder')
                        .empty()
                        .append(data.newOptions)
                        .dropdown({'fullTextSearch': true})
                        .dropdown('clear')
                        .dropdown('set text', 'Wybierz zamówienie');

                    $("#selectMagazyn option[value='0']").remove();
                    $('#selectMagazyn')
                        .dropdown({'fullTextSearch': true});
                    if(zamowienie > 0){
                        $('#selectOrder').dropdown('set value', zamowienie);
                    }


                } });
            }


        },

        submitForm: function (e) {

            var errors = [];
            if($('#selectMagazyn').val() == 0){
                errors.push("Należy wybrać magazyn");
            }
            if(($('#selectOrder').val() == 0 || $('#selectOrder').val() == null) && $('#multiCheckbox').prop('checked') == false){
                errors.push("Należy wybrać zamówienie");
            }
            if($('#selectPlik').val() == null || $('#selectPlik').val() == ''){
                errors.push("Należy wybrać plik");
            }

            if(errors.length > 0){
                var html = '<i class="close icon"></i>';
                $.each( errors, function( key, value ) {
                    html += value + '<br/>';
                });

                $('#divErrors').html(html);
                $('#divErrors').show();
            }else{
                $('#generateForm').submit();
            }



        },

        _inits: function (e) {
            $('.dropdown').dropdown({
                'fullTextSearch': true,
            });


            $('.chosen').chosen();

            $('.ui.checkbox').checkbox();


            jQuery.extend( jQuery.fn.dataTableExt.oSort, {
                "polish-string-asc" : function (s1, s2) {
                    return s1.localeCompare(s2);
                },

                "polish-string-desc" : function (s1, s2) {
                    return s2.localeCompare(s1);
                }
            } );

            var wHeight = window.innerHeight;


            var table = $('#dataTable').DataTable({
                responsive: false,
                fixedColumns: {
                    leftColumns: 4
                },
                scrollX: true,
                scrollY: (wHeight - 300) + "px",
                bPaginate: false,
                bLengthChange: false,
                bFilter: false,
                bInfo: false,
                bAutoWidth: false,
                columnDefs: [{
                    type: 'polish-string',
                    targets: 2
                }],
                aLengthMenu: [[-1, 10, 50, 100], ["Wszystkie", 10, 50, 100]],


            });


        },

    });

})(window, jQuery);