<?php

$router->group(['middleware' => 'simpleauth', 'prefix' => 'api/v1'], function () use ($router) {
    // Sprawdzenie czy na serwerze są zainstalowane wszystkie niezbędne rozszerzenia.
    $router->get('/', function () {
        return 'biblioteka PHP: com_dotnet...' . (extension_loaded('com_dotnet') ? 'OK' : 'BRAK') . "\r\n"
            . 'biblioteka PHP: sqlsrv...' . (extension_loaded('sqlsrv') ? 'OK' : 'BRAK') . "\r\n"
            . 'biblioteka PHP: pdo_sqlsrv...' . (extension_loaded('pdo_sqlsrv') ? 'OK' : 'BRAK') . "\r\n";
    });

    // Logi synchronizacji
    $router->get('/synchronizacja', [
        'as' => 'logs.show',
        'uses' => 'OrderController@showlogs',
    ]);

    // Produkty
    $router->post('/produkty', [
        'as' => 'products.store',
        'uses' => 'ProductController@store',
    ]);
    $router->get('/produkty/{symbol}', [
        'as' => 'products.show',
        'uses' => 'ProductController@show',
    ]);
    $router->put('/produkty/{symbol}', [
        'as' => 'products.update',
        'uses' => 'ProductController@update',
    ]);

    // Kontrahenci
    $router->post('/kontrahenci', [
        'as' => 'contractors.store',
        'uses' => 'ContractorController@store',
    ]);
    $router->get('/kontrahenci/{symbol}', [
        'as' => 'contractors.show',
        'uses' => 'ContractorController@show',
    ]);
    $router->put('/kontrahenci/{symbol}', [
        'as' => 'contractors.update',
        'uses' => 'ContractorController@update',
    ]);

    // Zamówienia
    $router->post('/zamowienia', [
        'as' => 'orders.store',
        'uses' => 'OrderController@store',
    ]);
    $router->post('/zamowienia/{id}/status', [
        'as' => 'orders.status',
        'uses' => 'OrderController@status',
    ]);
    $router->post('/zamowienia/zrealizuj', [
        'as' => 'orders.execute',
        'uses' => 'OrderController@execute',
    ]);
    $router->delete('/zamowienia/{id}', [
        'as' => 'orders.cancel',
        'uses' => 'OrderController@cancel',
    ]);
    $router->post('/zamowienia/{id}/pobranie', [
        'as' => 'orders.cod',
        'uses' => 'OrderController@cod',
    ]);
    $router->get('/zamowienia/{id}', [
        'as' => 'orders.show',
        'uses' => 'OrderController@show',
    ]);
});
