<?php

namespace App\Http\Controllers;

use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Laravel\Lumen\Routing\Controller as BaseController;
use Zoondo\Sfera\GT;
use Zoondo\Sfera\Program;

class Controller extends BaseController
{
    /**
     * @var GT Instancja programu Subiekt GT
     */
    protected $gt;

    public function __construct()
    {
        // Tworzy nową instancję Subiekta, jeśli jeszcze nie istnieje.
        if (!$this->gt) {
            $connection = config('database.default');
			$gtd = new \COM("InsERT.Dodatki") or die("Cannot create an InsERT.Dodatki object");

            $InsERT = new GT(
                config('database.connections.' . $connection . '.host'),
                config('database.connections.' . $connection . '.database'),
                config('database.connections.' . $connection . '.username'),
                config('database.connections.' . $connection . '.password'),
                config('project.insert.operator'),
                $gtd->Szyfruj(config('project.insert.operatorPassword'))
            );

            $this->gt = new Program(
                $InsERT,
                Program::SUBIEKT_GT,
                Program::ADJUST_OPERATOR,
               // Program::RUN_NEW_INSTANCE | 
			   Program::RUN_IN_BACKGROUND
            );
        }
    }

    /**
     * Metoda zwracająca kolejny wolny identyfikator dla podanej tabeli lub 0, jeśli nie udało się go pobrać.
     *
     * @param  string  $table Nazwa tabeli dla której pobieramy identyfikator
     *
     * @return int
     */
    protected function getId(string $table)
    {
        try {
            $sql = DB::select(
                "DECLARE @res INT; EXEC spIdentyfikator @nazwa = ?, @liczba = 1, @wynik = @res OUTPUT; SELECT @res AS 'id';",
                [ $table ]
            );
        } catch (QueryException $e) {
            return 0;
        }

        return $sql[0]->id;
    }
}
