<?php

namespace App\Console\Commands;

use Exception;
use GuzzleHttp\Client;
use Illuminate\Console\Command;
use Zoondo\Sfera\GT;
use Zoondo\Sfera\Program;

class SynchronizeWaybills extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'synchronize-waybills';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Synchronizuje numery listów przewozowych z Subiekta z zewnętrznym sklepem';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $connection = config('database.default');

        $InsERT = new GT(
            config('database.connections.' . $connection . '.host'),
            config('database.connections.' . $connection . '.database'),
            config('database.connections.' . $connection . '.username'),
            config('database.connections.' . $connection . '.password'),
            config('project.insert.operator'),
            config('project.insert.operatorPassword')
        );

        $gt = new Program(
            $InsERT,
            Program::SUBIEKT_GT,
            Program::ADJUST_OPERATOR,
            Program::RUN_IN_BACKGROUND
        );

        if (!$gt) {
            $this->log('error', 'Nie udało się uruchomić Subiekta by wysłać numery listów przewozowych');
        }

        $documents = [];
        $warehouse = config('project.warehouse', null);

        if ($warehouse) {
            $gt->MagazynId = (int) $warehouse;
        }

        foreach ($gt->Dokumenty as $document) {
            // Tylko ZK z flagą "Wysłane".
            if ($document->typ != 16 || $document->FlagaNazwa != 'Wysłane') {
                continue;
            }

            $documents[$document->NumerOryginalny] = $document->PoleWlasne['NR_LISTU_PRZEWOZOWEGO'];
        }

        $gt->Zakoncz();

        if (empty($documents)) {
            return;
        }

        try {
            $client = new Client();
            $response = $client->post(config('project.shop.urlWaybills') . '?token=' . config('project.shop.token'), [
                'json' => $documents,
                'connect_timeout' => 300,
                'timeout' => 300,
            ]);
            $this->log('success', 'Numery listów przewozowych wysłane, sklep zwrócił status: ' . $response->getBody()->getContents());
        } catch (Exception $e) {
            $this->log('error', 'Nie udało się wysłać numerów listów przewozowych, sklep zwrócił błąd: ' . $e->getMessage());
        }
    }

    protected function log($status, $message)
    {
        $status = strtoupper($status);

        if (!in_array($status, ['SUCCESS', 'ERROR', 'WARNING', 'INFO'])) {
            $status = 'INFO';
        }

        $log = implode(' ', [
            date('Y-m-d H:i:s'),
            $status,
            $message,
        ]) . PHP_EOL;
        file_put_contents(storage_path('synchronizacja.txt'), $log, FILE_APPEND);
    }
}
